% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/input-submit.R
\name{submitButton}
\alias{submitButton}
\title{Create a submit button}
\usage{
submitButton(text = "Apply Changes", icon = NULL)
}
\arguments{
\item{text}{Button caption}

\item{icon}{Optional \code{\link[shiny]{icon}} to appear on the button}
}
\value{
A submit button that can be added to a UI definition.
}
\description{
Create a submit button for an input form. Forms that include a submit
button do not automatically update their outputs when inputs change,
rather they wait until the user explicitly clicks the submit button.
}
\examples{
library(shiny)
submitButton("Update View")
submitButton("Update View", icon("refresh"))
}
\seealso{
Other input.elements: \code{\link{animationOptions}},
  \code{\link{sliderInput}};
  \code{\link{checkboxGroupInput}};
  \code{\link{checkboxInput}}; \code{\link{dateInput}};
  \code{\link{dateRangeInput}}; \code{\link{numericInput}};
  \code{\link{radioButtons}}; \code{\link{selectInput}},
  \code{\link{selectizeInput}}; \code{\link{textInput}}
}

