% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-gif.R
\name{manual-gif}
\alias{manual-gif}
\alias{use_busy_gif}
\alias{play_gif}
\alias{stop_gif}
\title{Manual busy indicator (GIF)}
\usage{
use_busy_gif(
  src,
  timeout = 100,
  position = c("top-right", "top-left", "bottom-right", "bottom-left", "full-page",
    "free"),
  margins = c(10, 10),
  overlay_color = "rgba(0, 0, 0, 0.5)",
  overlay_css = NULL,
  height = "50px",
  width = "50px"
)

play_gif(session = shiny::getDefaultReactiveDomain())

stop_gif(session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{src}{Path to the GIF, an URL or a file in www/ folder.}

\item{timeout}{Number of milliseconds after the server is busy to display the GIF.}

\item{position}{Where to display the GIF: \code{'top-right'}, \code{'top-left'}, \code{'bottom-right'},
\code{'bottom-left'}, \code{'full-page'}.}

\item{margins}{Distance from margins, a vector of length two, where first element is distance from top/bottom,
second element distance from right/left.}

\item{overlay_color}{Background color for the overlay if \code{position = "full-page"}.}

\item{overlay_css}{Additional CSS for the overlay, for example \code{"z-index: 1000;"} to make it appear above everything.}

\item{height, width}{Height and width of the spinner, default to \code{'50px'} for both, must be specified.}

\item{session}{Shiny session.}
}
\value{
An HTML tag that should be used in UI.
}
\description{
Manual busy indicator (GIF)
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(

  # Use this function somewhere in UI
  use_busy_gif(
    src = "https://jeroen.github.io/images/banana.gif",
    height = 70, width = 70
  ),

  actionButton("play", "Play GIF"),
  actionButton("stop", "Stop GIF")
)

server <- function(input, output, session) {

  observeEvent(input$play, {
    play_gif()
  })

  observeEvent(input$stop, {
    stop_gif()
  })

}

if (interactive()) {
  shinyApp(ui, server)
}
}
