% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starBlock.R
\name{starBlock}
\alias{starBlock}
\title{AdminLTE2 starBlock}
\usage{
starBlock(maxstar = 5, grade, color = "yellow")
}
\arguments{
\item{maxstar}{Maximum number of stars by block.}

\item{grade}{Current score. Should be positive and lower or equal to maxstar.}

\item{color}{Star color: see \code{validColors()} in the documentation.}
}
\description{
Create a starBlock item (ideal for rating)
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Star example",
      starBlock(grade = 5),
      starBlock(grade = 5, color = "olive"),
      starBlock(grade = 1, color = "maroon"),
      starBlock(grade = 3, color = "teal")
     )
    ),
    title = "starBlock"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
