% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_animation.R
\name{Class_animation}
\alias{Class_animation}
\alias{jqui_add_class}
\alias{jqui_remove_class}
\alias{jqui_switch_class}
\title{Add/remove/switch class(es) with animating.}
\usage{
jqui_add_class(selector, className, duration = 400, easing = "swing",
  complete = NULL)

jqui_remove_class(selector, className, duration = 400, easing = "swing",
  complete = NULL)

jqui_switch_class(selector, removeClassName, addClassName, duration = 400,
  easing = "swing", complete = NULL)
}
\arguments{
\item{selector}{A \href{https://api.jquery.com/category/selectors/}{jQuery's
selector} that determines the shiny tag element(s) whose interaction is
enable or disable interactions.}

\item{className}{One or more class names (space separated) to be added to or
removed from the class attribute of each matched element.}

\item{duration}{A string or number determining how long the animation will
run.}

\item{easing}{A string indicating which
\href{http://api.jqueryui.com/easings/}{easing} function to use for the
transition.}

\item{complete}{A js function to call once the animation is complete, called
once per matched element.}

\item{removeClassName}{One or more class names (space separated) to be
removed from the class attribute of each matched element.}

\item{addClassName}{One or more class names (space separated) to be added to
the class attribute of each matched element.}
}
\description{
These functions are the R wrappers of
\href{http://api.jqueryui.com/addClass/}{addClass()},
\href{http://api.jqueryui.com/addClass/}{removeClass()},
\href{http://api.jqueryui.com/addClass/}{switchClass()} in jQuery UI library.
They should be used in \code{server} of a shiny document.
}
\details{
\describe{ \item{\code{jqui_add_class}}{Adds the specified class(es) to each
of the set of matched elements while animating all style changes.}
\item{\code{jqui_remove_class}}{Removes the specified class(es) from each of
the set of matched elements while animating all style changes.}
\item{\code{jqui_switch_class}}{Adds and removes the specified class(es) to
each of the set of matched elements while animating all style changes} }
}
\examples{
\dontrun{
  # in shiny ui create a span
  tags$span(id = 'foo', 'class animation demo')

  # in shiny server add class 'lead' to the span
  jqui_add_class('#foo', className = 'lead')
}
}

