% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onevent.R
\name{onevent}
\alias{onclick}
\alias{onevent}
\title{Run R code when an event is triggered on an element}
\usage{
onclick(id, expr, add = FALSE)

onevent(event, id, expr, add = FALSE)
}
\arguments{
\item{id}{The id of the element/Shiny tag}

\item{expr}{The R expression to run after the event is triggered}

\item{add}{If \code{TRUE}, then add \code{expr} to be executed after any
other code that was previously set using \code{onevent} or \code{onclick}; otherwise
\code{expr} will overwrite any previous expressions. Note that this parameter
works well in web browsers but is buggy when using the RStudio Viewer.}

\item{event}{The event that needs to be triggered to run the code. See below
for a list of possible event types.}
}
\description{
\code{onclick} runs an R expression (either a \code{shinyjs} function or any other code)
when an element is clicked.\cr\cr
\code{onevent} is similar, but can be used when any event is triggered on the element,
not only a mouse click. See below for a list of possible event types. Using "click"
results in the same behaviour as calling \code{onclick}.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\section{Possible event types}{

Any \href{http://api.jquery.com/category/events/mouse-events/}{mouse} or
\href{http://api.jquery.com/category/events/keyboard-events/}{keyboard} events
that are supported by JQuery can be used. The full list of events that can be used is:
\code{click}, \code{dblclick}, \code{hover}, \code{mousedown}, \code{mouseenter},
\code{mouseleave}, \code{mousemove}, \code{mouseout}, \code{mouseover}, \code{mouseup},
\code{keydown}, \code{keypress}, \code{keyup}.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::p(id = "date", "Click me to see the date"),
      shiny::p(id = "disappear", "Move your mouse here to make the text below disappear"),
      shiny::p(id = "text", "Hello")
    ),
    server = function(input, output) {
      onclick("date", info(date()))
      onevent("mouseenter", "disappear", hide("text"))
      onevent("mouseleave", "disappear", show("text"))
    }
  )
}
\dontrun{
  # The shinyjs function call in the above app can be replaced by
  # any of the following examples to produce similar Shiny apps
  onclick("disappear", toggle("text"))
  onclick(expr = text("date", date()), id = "date")
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{runExample}}
}

