pkgEnv <- new.env()

pkgEnv$label_en = list(
  "Please authenticate" = "Please authenticate",
  "Username:" = "Username :",
  "Password:" = "Password :",
  "Login" = "Login",
  "Username or password are incorrect" = "Username or password are incorrect",
  "Your account has expired" = "Your account has expired",
  "Please change your password" = "Please change your password",
  "New password:" = "New password :",
  "Confirm password:" = "Confirm password :",
  "Update new password" = "Update new password",
  "Password successfully updated! Please re-login" = "Password successfully updated! Please re-login",
  "The two passwords are different" = "The two passwords are different",
  "Failed to update password" = "Failed to update password",
  "Logout" = "Logout",
  "Go to application" = "Go to application",
  "Administrator mode" = "Administrator mode",
  "Add a user" = "Add a user",
  "Too many users" = "Too many users",
  "Maximum number of users : %s" = "Maximum number of users : %s",
  "Failed to update user" = "Failed to update user",
  "User successfully updated" = "User successfully updated",
  "Cancel" = "Cancel",
  "Confirm new user" = "Confirm new user",
  "Confirm change" = "Confirm change",
  "Are you sure to remove user(s): %s from the database ?" = "Are you sure to remove user(s): %s from the database ?",
  "Delete user(s)" = "Delete user(s)",
  "Delete user" = "Delete user",
  "Edit user" = "Edit user",
  "User already exist!" = "User already exist!",
  "Dismiss" = "Dismiss",
  "New user %s succesfully created!" = "New user %s succesfully created!",
  "Ask to change password" = "Ask to change password",
  "Confirm" = "Confirm",
  "Ask %s to change password on next connection?" = "Ask %s to change password on next connection?",
  "Change saved!" = "Change saved!",
  "Failed to update the database" = "Failed to update the database",
  "Password does not respect safety requirements" = "Password does not respect safety requirements",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6.",
  "Number of connections per user" = "Number of connections per user",
  "Number of connections per day" = "Number of connections per day",
  "Total number of connection" = "Total number of connection",
  "You can\'t remove yourself!" = "You can\'t remove yourself!",
  "User:" = "User :",
  "Period:" = "Period :",
  "Last week" = "Last week",
  "Last month" = "Last month",
  "All period" = "All period",
  "Home" = "Home",
  "Select all shown users" = "Select all shown users",
  "Remove selected users" = "Remove selected users",
  "Edit selected users" = "Edit selected users",
  "Force selected users to change password" = "Force selected users to change password",
  "Users" = "Users",
  "Passwords" = "Passwords",
  "Download logs database" = "Download logs database",
  "Download SQL database" = "Download SQL database",
  "Reset password for %s?" = "Reset password for %s?",
  "Reset password" = "Reset password",
  "Temporary password:" = "Temporary password:",
  "Password succesfully reset!" = "Password succesfully reset!",
  "You are not authorized for this application" = "You are not authorized for this application",
  "Language"  = "Language", 
  "Yes" = "Yes",
  "No" = "No",
  "Password" = "Password",
  "start" = "start",
  "expire" = "expire",
  "admin" = "Admin",
  "user" = "User",
  "Edit" = "Edit",
  "Remove" = "Remove",
  "must_change" = "Must Change",
  "have_changed" = "Have Changed",
  "date_change" = "Date",
  "Change password" = "Change password",
  "Select" = "Select",
  "Logs" = "Logs",
  "All users" = "All users",
  "Nb logged" = "Nb logged",
  "Allowed null values" = "Allowed null values"
)

pkgEnv$label_fr = list(
  "Please authenticate" = "Veuillez vous authentifier",
  "Username:" = "Nom d\'utilisateur :",
  "Password:" = "Mot de passe :",
  "Login" = "Se connecter",
  "Username or password are incorrect" = "Nom d\'utilisateur ou mot de passe incorrect",
  "Your account has expired" = "Votre compte a expir\u00e9",
  "Please change your password" = "Veuillez changer votre mot de passe",
  "New password:" = "Nouveau mot de passe :",
  "Confirm password:" = "Confirmez le mot de passe :",
  "Update new password" = "Mettre \u00e0 jour",
  "Password successfully updated! Please re-login" = "Mot de passe modifi\u00e9! Veuillez vous reconnecter",
  "The two passwords are different" = "Les deux mots de passe sont diff\u00e9rents",
  "Failed to update password" = "Echec de la mise \u00e0 jour du mot de passe",
  "Logout" = "Se d\u00e9connecter",
  "Go to application" = "Aller \u00e0 l\'application",
  "Administrator mode" = "Mode administrateur",
  "Add a user" = "Ajouter un utilisateur",
  "Too many users" = "Trops d'utilisateur",
  "Maximum number of users : %s" = "Nombre maximum : %s",
  "Failed to update user" = "Echec de la mise \u00e0 jour de l\'utilisateur",
  "User successfully updated" = "Mise \u00e0 jour r\u00e9ussie",
  "Cancel" = "Annuler",
  "Confirm new user" = "Valider l\'ajout",
  "Confirm change" = "Valider les modifications",
  "Are you sure to remove user(s): %s from the database ?" = "Etes-vous s\u00fbr de vouloir supprimer %s de la base de donn\u00e9es ?",
  "Delete user(s)" = "Supprimer l\'/les utilisateur(s)",
  "Delete user" = "Supprimer l\'utilisateur",
  "Edit user" = "Modifier l\'utilisateur",
  "User already exist!" = "L\'utilisateur existe d\u00e9j\u00e0",
  "Dismiss" = "Fermer",
  "New user %s succesfully created!" = "Nouvel utilisateur %s cr\u00e9\u00e9 avec succ\u00e8s !",
  "Ask to change password" = "Demander \u00e0 changer le mot de passe",
  "Confirm" = "Confirmer",
  "Ask %s to change password on next connection?" = "Demander \u00e0 %s de changer son mot de passe \u00e0 la prochaine connexion ?",
  "Change saved!" = "Changements sauvegard\u00e9s !",
  "Failed to update the database" = "Une erreur s\'est produite",
  "Password does not respect safety requirements" = "Le mot de passe ne respecte les r\u00e8gles de s\u00e9curit\u00e9",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "Le mot de passe doit contenir au minimum un chiffre, une lettre majuscule, une lettre minuscule et doit \u00eatre au moins de longueur 6.",
  "Number of connections per user" = "Nombre de connexions par utilisateur",
  "Number of connections per day" = "Nombre de connexions par jour",
  "Total number of connection" = "Nombre total de connexions",
  "You can\'t remove yourself!" = "Vous ne pouvez pas supprimer votre propre compte!",
  "User:" = "Utilisateur :",
  "Period:" = "P\u00e9riode :",
  "Last week" = "Semaine derni\u00e8re",
  "Last month" = "Mois dernier",
  "All period" = "P\u00e9riode enti\u00e8re",
  "Home" = "Accueil",
  "Select all shown users" = "S\u00e9lectionner tous les utilisateurs affich\u00e9s",
  "Remove selected users" = "Supprimer les utilisateurs s\u00e9lectionn\u00e9s",
  "Edit selected users" = "Editer les utilisateurs s\u00e9lectionn\u00e9s",
  "Force selected users to change password" = "Forcer les utilisateurs s\u00e9l\u00e9ctionn\u00e9s \u00e0 changer de mot de passe",
  "Users" = "Utilisateurs",
  "Passwords" = "Mots de passe",
  "Download logs database" = "T\u00e9l\u00e9charger les logs",
  "Download SQL database" = "T\u00e9l\u00e9charger la base SQL",
  "Reset password for %s?" = "R\u00e9initialiser le mot de passe de %s ?",
  "Reset password" = "R\u00e9initialiser le mot de passe",
  "Temporary password:" = "Mot de passe temporaire",
  "Password succesfully reset!" = "Mot de passe r\u00e9initialis\u00e9",
  "You are not authorized for this application" = "Vous n\'\u00eates pas habilit\u00e9 pour cette application",
  "Language"  = "Langue",
  "Yes" = "Oui",
  "No" = "Non",
  "Password" = "Mot de passe",
  "start" = "D\u00e9but",
  "expire" = "Fin",
  "admin" = "Administrateur",
  "user" = "utilisateur",
  "Edit" = "Modifier",
  "Remove" = "Supprimer",
  "must_change" = "\u00c0 r\u00e9initialis\u00e9r",
  "have_changed" = "R\u00e9initialis\u00e9",
  "date_change" = "Date",
  "Change password" = "Changer le mot de passe",
  "Select" = "S\u00e9lectionner",
  "Logs" = "Logs",
  "All users" = "Tous les utilisateurs",
  "Nb logged" = "Connexions",
  "Allowed null values" = "Valeurs nulles autoris\u00e9es"
)

pkgEnv$label_ptbr = list(
  "Please authenticate" = "Autentica\u00e7\u00e3o",
  "Username:" = "Usu\u00e1rio :",
  "Password:" = "Senha :",
  "Login" = "Conectar",
  "Username or password are incorrect" = "Usu\u00e1rio ou senha incorreto",
  "Your account has expired" = "Sua conta expirou",
  "Please change your password" = "Por favor, mude sua senha",
  "New password:" = "Nova senha :",
  "Confirm password:" = "Confirmar nova senha:",
  "Update new password" = "Atualizar nova senha",
  "Password successfully updated! Please re-login" = "Senha alterada com sucesso! Por favor, autentique-se novamente",
  "The two passwords are different" = "As duas senhas s\u00e3o diferentes",
  "Failed to update password" = "Falha em atualizar a senha",
  "Logout" = "Desconectar",
  "Go to application" = "Ir \u00e0 aplica\u00e7\u00e3o",
  "Administrator mode" = "Modo administrador",
  "Add a user" = "Adicionar usu\u00e1rio",
  "Too many users" = "Muitos usu\u00e1rios",
  "Maximum number of users : %s" = "N\u00f9mero m\u00e1ximo : %s",
  "Failed to update user" = "Falha em atualizar usu\u00e1rio",
  "User successfully updated" = "Usu\u00e1rio atualizado com sucesso",
  "Cancel" = "Cancelas",
  "Confirm new user" = "Confirmar novo usu\u00e1rio",
  "Confirm change" = "Confirmar mudan\u00e7a",
  "Are you sure to remove user(s): %s from the database ?" = "Tem certeza que deseja remover o(s) usu\u00e1rio(s) %s do banco de dados?",
  "Delete user(s)" = "Deletar usu\u00e1rio(s)",
  "Delete user" = "Deletar usu\u00e1rio",
  "Edit user" = "Modificar usu\u00e1rio",
  "User already exist!" = "O usu\u00e1rio j\u00e1 existe!",
  "Dismiss" = "Fechar",
  "New user %s succesfully created!" = "Novo usu\u00e1rio %s criado com sucesso!",
  "Ask to change password" = "Pedir para alterar a senha",
  "Confirm" = "Confirmar",
  "Ask %s to change password on next connection?" = "Pedir a %s para alterar a senha na pr\u00f3xima conex\u00e3o?",
  "Change saved!" = "Mudan\u00e7as salvas!",
  "Failed to update the database" = "Erro em atualizar o banco de dados",
  "Password does not respect safety requirements" = "Senha n\u00e3o conforme com as exig\u00eancias de seguran\u00e7a",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "A senha deve conter pelo menos um n\u00famero, uma letra min\u00fascula, uma letra mai\u00fascula e deve ter pelo menos 6 caracteres",
  "Number of connections per user" = "N\u00famero de conex\u00f5es por usu\u00e1rio",
  "Number of connections per day" = "N\u00famero de conex\u00f5es por dia",
  "Total number of connection" = "N\u00famero total de conex\u00f5es",
  "You can\'t remove yourself!" = "Voc\u00ea n\u00e3o pode se remover!",
  "User:" = "Usu\u00e1rio :",
  "Period:" = "Per\u00edodo :",
  "Last week" = "Semana passada",
  "Last month" = "M\u00eas passado",
  "All period" = "Todo per\u00edodo",
  "Home" = "In\u00edcio",
  "Select all shown users" = "Selecionar todos os usu\u00e1rios mostrados",
  "Remove selected users" = "Remover usu\u00e1rios selecionados",
  "Edit selected users" = "Modificar usu\u00e1rios selecionados",
  "Force selected users to change password" = "For\u00e7ar usu\u00e1rio selecionado a mudar a senha",
  "Users" = "Usu\u00e1rios",
  "Passwords" = "Senhas",
  "Download logs database" = "Fazer download dos logs do banco de dados",
  "Download SQL database" = "Fazer download do banco de dados SQL",
  "Reset password for %s?" = "Resetar a senha de %s?",
  "Reset password" = "Resetar a senha",
  "Temporary password:" = "Senha tempor\u00e1ria",
  "Password succesfully reset!" = "Senha resetada com sucesso!",
  "You are not authorized for this application" = "Voc\u00ea n\u00e3o est\u00e1 autorizado a utilizar esse aplicativo",
  "Language"  = "L\u00edngua",
  "Yes" = "Sim",
  "No" = "N\u00e3o",
  "Password" = "Senha",
  "start" = "In\u00edcio",
  "expire" = "Fim",
  "admin" = "Administrador",
  "user" = "usu\u00e1rio",
  "Edit" = "Modificar",
  "Remove" = "Deletar",
  "must_change" = "Deve mudar",
  "have_changed" = "Mudaram",
  "date_change" = "Data",
  "Change password" = "Alterar a senha",
  "Select" = "Selecionar",
  "Logs" = "Conex\u00f5es",
  "All users" = "All usu\u00e1rio",
  "Nb logged" = "Conex\u00f5es",
  "Allowed null values" = "Valores nulos autorizados"
)

pkgEnv$label_es = list(
  "Please authenticate" = "Favor de autenticarse",
  "Username:" = "Usuario:",
  "Password:" = "Contrase\u00f1a:",
  "Login" = "Iniciar sesi\u00f3n",
  "Username or password are incorrect" = "Usuario o contrase\u00f1a incorrecto",
  "Your account has expired" = "Su cuenta ha expirado",
  "Please change your password" = "Por favor, cambie su contrase\u00f1a",
  "New password:" = "Nueva contrase\u00f1a:",
  "Confirm password:" = "Confirme contrase\u00f1a:",
  "Update new password" = "Actualizar nueva contrase\u00f1a",
  "Password successfully updated! Please re-login" = "\u00a1Cambio de contrase\u00f1a exitoso! Por favor, vuelva a iniciar sesi\u00f3n",
  "The two passwords are different" = "Las dos contrase\u00f1as son diferentes",
  "Failed to update password" = "Fall\u00f3 la actualizaci\u00f3n de la contrase\u00f1a",
  "Logout" = "Cerrar sesi\u00f3n",
  "Go to application" = "Ir a aplicaci\u00f3n",
  "Administrator mode" = "Modo administraci\u00f3n",
  "Add a user" = "Agregar usuario",
  "Too many users" = "Demasiado usuario",
  "Maximum number of users : %s" = "N\u00famero m\u00e1ximo de usuarios : %s",
  "Failed to update user" = "Fall\u00f3 la actualizaci\u00f3n del usuario",
  "User successfully updated" = "Usuario actualizado correctamente",
  "Cancel" = "Cancelar",
  "Confirm new user" = "Confirmar nuevo usuario",
  "Confirm change" = "Confirmar cambio",
  "Are you sure to remove user(s): %s from the database ?" = "\u00bfEst\u00e1 seguro de remover el(los) usuario(s): %s de la base de datos?",
  "Delete user(s)" = "Borrar usuario(s)",
  "Delete user" = "Borrar usuario",
  "Edit user" = "Editar usuario",
  "User already exist!" = "\u00a1Usuario ya existente!",
  "Dismiss" = "Descartar",
  "New user %s succesfully created!" = "\u00a1Nuevo usuario %s creado satisfactoriamente!",
  "Ask to change password" = "Pedir que cambie la contrase\u00f1a",
  "Confirm" = "Confirmar",
  "Ask %s to change password on next connection?" = "\u00bfDesea pedir a %s que cambie la contrase\u00f1a en su siguiente connexi\u00f3n?",
  "Change saved!" = "\u00a1Cambio guardado!",
  "Failed to update the database" = "Fall\u00f3 la actualizaci\u00f3n de la base de datos",
  "Password does not respect safety requirements" = "La contrase\u00f1a no contiene los requerimientos de seguridad",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "La contrase\u00f1a debe contener al menos un n\u00famero, una m\u00ednuscula, una may\u00fascula y debe ser de almenos seis caracteres.",
  "Number of connections per user" = "N\u00famero de conexiones por usuario",
  "Number of connections per day" = "N\u00famero de conexiones por d\u00eda",
  "Total number of connection" = "Total de conexiones",
  "You can\'t remove yourself!" = "No puede eliminarse usted mismo",
  "User:" = "Usuario:",
  "Period:" = "Periodo:",
  "Last week" = "Semana pasada",
  "Last month" = "Mes pasado",
  "All period" = "Todo el periodo",
  "Home" = "Inicio",
  "Select all shown users" = "Seleccionar todos los usuarios mostrados",
  "Remove selected users" = "Remover los usuarios seleccionados",
  "Edit selected users" = "Editar los usuarios seleccionados",
  "Force selected users to change password" = "Forzar a los usuarios seleccionados que cambien la contrase\u00f1a",
  "Users" = "Usuarios",
  "Passwords" = "Contrase\u00f1as",
  "Download logs database" = "Descargar la base de datos de registros",
  "Download SQL database" = "Descargar la base de datos SQL",
  "Reset password for %s?" = "\u00bfReiniciar contrase\u00f1a para %s?",
  "Reset password" = "Reiniciar",
  "Temporary password:" = "Contrase\u00f1a temporal:",
  "Password succesfully reset!" = "\u00a1Contrase\u00f1a reiniciada satisfactoriamente!",
  "You are not authorized for this application" = "No est\u00e1s autorizado para esta aplicaci\u00f3n",
  "Language" = "Lenguaje",
  "Yes" = "S\u00ed",
  "No" = "No",
  "Password" = "Contrase\u00f1a",
  "start" = "empieza",
  "expire" = "expira",
  "admin" = "administrador",
  "user" = "usuario",
  "Edit" = "Editar",
  "Remove" = "Eliminar",
  "must_change" = "Cambiar\u00e1 contrase\u00f1a",
  "have_changed" = "Cambi\u00f3 contrase\u00f1a",
  "date_change" = "Fecha de cambio",
  "Change password" = "Cambiar",
  "Select" = "Seleccionar",
  "Logs" = "Registros",
  "All users" = "Todos los usuarios",
  "Nb logged" = "Conexiones",
  "Allowed null values" = "Valores nulos permitidos"
)

pkgEnv$label_de = list(
  "Please authenticate" = "Bitte anmelden",
  "Username:" = "Benutzername :",
  "Password:" = "Passwort :",
  "Login" = "Anmelden",
  "Username or password are incorrect" = "Benutzername oder Passwort falsch",
  "Your account has expired" = "Account ist abgelaufen",
  "Please change your password" = "Bitte Passwort \u00e4ndern",
  "New password:" = "Neues Passwort :",
  "Confirm password:" = "Passwort best\u00e4tigen :",
  "Update new password" = "Passwort aktualisieren",
  "Password successfully updated! Please re-login" = "Passwort erfolgreich aktualisiert! Bitte neu anmelden.",
  "The two passwords are different" = "Passw\u00f6rter nicht gleich",
  "Failed to update password" = "Passwortaktualisierung fehlgeschlagen",
  "Logout" = "Abmelden",
  "Go to application" = "Starte Anwendung",
  "Administrator mode" = "Administrator Modus",
  "Add a user" = "Benutzer hinzuf\u00fcgen",
  "Too many users" = "zu viele Benutzer",
  "Maximum number of users : %s" = "Maximale Benutzeranzahl : %s",
  "Failed to update user" = "Benutzeraktualisierung fehlgeschlagen",
  "User successfully updated" = "Benutzer erfolgreich aktualisiert",
  "Cancel" = "Abbruch",
  "Confirm new user" = "Benutzer best\u00e4tigen",
  "Confirm change" = "\u00c4nderung best\u00e4tigen",
  "Are you sure to remove user(s): %s from the database ?" = "Wirklich Benutzer: %s aus der Datenbank l\u00f6schen?",
  "Delete user(s)" = "Benutzer l\u00f6schen",
  "Delete user" = "Benutzer l\u00f6schen",
  "Edit user" = "Benutzer bearbeiten",
  "User already exist!" = "Benutzer existiert bereits!",
  "Dismiss" = "Schliessen",
  "New user %s succesfully created!" = "Neuer Benutzer %s erfolgreich erstellt!",
  "Ask to change password" = "Aufforderung zur Passwort\u00e4nderung",
  "Confirm" = "Best\u00e4tigen",
  "Ask %s to change password on next connection?" = "Aufforderung zur Passwort\u00e4nderung f\u00fcr Benutzer: %s bei n\u00e4chster Anmeldung?",
  "Change saved!" = "\u00c4nderungen gespeichert!",
  "Failed to update the database" = "Datenbankaktualisierung fehlgeschlagen",
  "Password does not respect safety requirements" = "Passwort entspricht nicht den Sicherheitsanforderungen",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "Das Passwort muss mindestens eine Zahl, einen Kleinbuchstaben und einen Grossbuchstaben enthalten und mindestens 6 Zeichen lang sein.",
  "Number of connections per user" = "Verbindungen pro Benutzer",
  "Number of connections per day" = "Verbindungen pro Tag",
  "Total number of connection" = "Anzahl Verbindungen",
  "You can\'t remove yourself!" = "Der eigene Account kann nicht gel\u00f6scht werden!",
  "User:" = "Benutzer :",
  "Period:" = "Zeitraum :",
  "Last week" = "Letzte Woche",
  "Last month" = "Letzter Monat",
  "All period" = "Gesamter Zeitraum",
  "Home" = "Anfang",
  "Select all shown users" = "Alle angezeigten Benutzer ausw\u00e4hlen",
  "Remove selected users" = "Ausgew\u00e4hlte Benutzer l\u00f6schen",
  "Edit selected users" = "Ausgew\u00e4hlte Benutzer bearbeiten",
  "Force selected users to change password" = "F\u00fcr ausgew\u00e4hlte Benutzer Passwort\u00e4nderung erzwingen",
  "Users" = "Benutzer",
  "Passwords" = "Passw\u00f6rter",
  "Download logs database" = "Protokolldatenbank herunterladen",
  "Download SQL database" = "SQL Datenbank herunterladen",
  "Reset password for %s?" = "Passwort f\u00fcr %s zur\u00fccksetzen?",
  "Reset password" = "Passwort zur\u00fccksetzen",
  "Temporary password:" = "Tempor\u00e4res Passwort:",
  "Password succesfully reset!" = "Passwort erfolgreich zur\u00fcckgesetzt!",
  "You are not authorized for this application" = "F\u00fcr diese Anwendung nicht autorisiert",
  "Language"  = "Sprache", 
  "Yes" = "Ja",
  "No" = "Nein",
  "Password" = "Passwort",
  "start" = "Start",
  "expire" = "Verf\u00e4llt",
  "admin" = "Admin",
  "user" = "Benutzer",
  "Edit" = "Bearbeiten",
  "Remove" = "Entfernen",
  "must_change" = "\u00c4nderung erzwingen",
  "have_changed" = "ge\u00e4ndert",
  "date_change" = "\u00c4nderungsdatum",
  "Change password" = "Passwort \u00e4ndern",
  "Select" = "Ausw\u00e4hlen",
  "Logs" = "Protokolle",
  "All users" = "Alle Benutzer",
  "Nb logged" = "Verbindungen",
  "Allowed null values" = "Nullwerte erlaubt"
)

pkgEnv$label_pl = list(
  "Please authenticate" = "Prosz\u0119 o uwierzytelnienie",
  "Username:" = "Nazwa u\u017Cytkownika :",
  "Password:" = "Has\u0142o :",
  "Login" = "Zaloguj",
  "Username or password are incorrect" = "Nazwa u\u017Cytkownika lub has\u0142o s\u0105 nieprawid\u0142owe",
  "Your account has expired" = "Twoje konto jest nieaktywne",
  "Please change your password" = "Prosz\u0119 zmieni\u0107 has\u0142o",
  "New password:" = "Nowe has\u0142o :",
  "Confirm password:" = "Potwierd\u017A has\u0142o :",
  "Update new password" = "Zaktualizuj has\u0142o",
  "Password successfully updated! Please re-login" = "Has\u0142o pomy\u015Blnie zaktualizowane! Prosz\u0119 o ponowne zalogowanie",
  "The two passwords are different" = "Podane has\u0142a nie s\u0105 identyczne",
  "Failed to update password" = "Akualizacja has\u0142a zako\u0144czona niepowodzeniem",
  "Logout" = "Wyloguj",
  "Go to application" = "Przejd\u017A do aplikacji",
  "Administrator mode" = "Tryb administratora",
  "Add a user" = "Dodaj u\u017Cytkownika",
  "Too many users" = "Zbyt du\u017Co u\u017Cytkownik\u00F3w",
  "Maximum number of users : %s" = "Maksymalna liczba u\u017Cytkownik\u00F3w : %s",
  "Failed to update user" = "Aktualizacja u\u017Cytkownika zako\u0144czona niepowodzeniem",
  "User successfully updated" = "Pomy\u015Blnie zaktualizowano u\u017Cytkownika",
  "Cancel" = "Anuluj",
  "Confirm new user" = "Utw\u00F3rz nowego u\u017Cytkownika",
  "Confirm change" = "Potwierd\u017A wprowadzone zmiany",
  "Are you sure to remove user(s): %s from the database ?" = "Czy na pewno usun\u0105\u0107 u\u017Cytkownika/\u00F3w %s z bazy danych ?",
  "Delete user(s)" = "Usu\u0144 u\u017Cytkownika/\u00F3w",
  "Delete user" = "Usu\u0144 u\u017Cytkownika",
  "Edit user" = "Edytuj u\u017Cytkownika",
  "User already exist!" = "U\u017Cytkownik ju\u017C istnieje !",
  "Dismiss" = "Zamknij",
  "New user %s succesfully created!" = "Nowy u\u017Cytkownik: %s pomy\u015Blnie utworzony !",
  "Ask to change password" = "Popro\u015B o zmian\u0119 has\u0142a",
  "Confirm" = "Potwierd\u017A",
  "Ask %s to change password on next connection?" = "Popro\u015B %s o zmian\u0119 has\u0142a przy ponownym po\u0142\u0105czeniu ?",
  "Change saved!" = "Zmiana zapisana !",
  "Failed to update the database" = "B\u0142\u0105d przy pr\u00F3bie aktualizacji bazy danych",
  "Password does not respect safety requirements" = "Has\u0142o nie spe\u0142nia wymog\u00F3w bezpiecze\u0144stwa",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "Has\u0142o musi zawiera\u0107 co najmniej jedn\u0105 liczb\u0119, jedn\u0105 ma\u0142\u0105 oraz jedn\u0105 wielk\u0105 liter\u0119 i musi sk\u0142ada\u0107 si\u0119 z co najmniej 6 znak\u00F3w.",
  "Number of connections per user" = "Liczba po\u0142\u0105cze\u0144 na u\u017Cytkownika",
  "Number of connections per day" = "Liczba po\u0142\u0105cze\u0144 dziennie",
  "Total number of connection" = "Ca\u0142kowita liczba po\u0142\u0105cze\u0144",
  "You can\'t remove yourself!" = "Nie mo\u017Cesz usun\u0105\u0107 siebie!",
  "User:" = "U\u017Cytkownik :",
  "Period:" = "Okres :",
  "Last week" = "Ostatni tydzie\u0144",
  "Last month" = "Ostatni miesi\u0105c",
  "All period" = "Pe\u0142ny okres",
  "Home" = "G\u0142\u00F3wny panel",
  "Select all shown users" = "Wybierz wszystkich widocznych u\u017Cytkownik\u00F3w",
  "Remove selected users" = "Usu\u0144 wybranych u\u017Cytkownik\u00F3w",
  "Edit selected users" = "Edytuj wybranych u\u017Cytkownik\u00F3w",
  "Force selected users to change password" = "Wymu\u015B zmian\u0119 has\u0142a przez wybranych u\u017Cytkownik\u00F3w",
  "Users" = "U\u017Cytkownicy",
  "Passwords" = "Has\u0142a",
  "Download logs database" = "Pobierz baz\u0119 log\u00F3w",
  "Download SQL database" = "Pobierz baz\u0119 SQL",
  "Reset password for %s?" = "Resetuj has\u0142o dla %s ?",
  "Reset password" = "Resetuj has\u0142o",
  "Temporary password:" = "Has\u0142o tymczasowe",
  "Password succesfully reset!" = "Reset has\u0142a zako\u0144czony powodzeniem!",
  "You are not authorized for this application" = "Nie masz autoryzacji dla tej aplikacji",
  "Language"  = "J\u0119zyk",
  "Yes" = "Tak",
  "No" = "Nie",
  "Password" = "Has\u0142o",
  "start" = "Data aktywacji",
  "expire" = "Termin wa\u017Ano\u015Bci",
  "admin" = "Administrator",
  "user" = "U\u017Cytkownik",
  "Edit" = "Edytuj",
  "Remove" = "Usu\u0144",
  "must_change" = "Wym\u00F3g zmiany has\u0142a",
  "have_changed" = "Zmieniono",
  "date_change" = "Data",
  "Change password" = "Zmie\u0144 has\u0142o",
  "Select" = "Wybierz",
  "Logs" = "Logi",
  "All users" = "Wszyscy u\u017Cytkownicy",
  "Nb logged" = "Liczba logowa\u0144",
  "Allowed null values" = "Dozwolone warto\u015Bci zerowe"
)

v_language_registered = c("en", "fr", "pt-BR", "es", "de", "pl")
names(v_language_registered) = c("English", "Fran\u00e7ais", "Portuguese", "Espa\u00f1ol", "Deutsch", "Polski")

#' @importFrom R6 R6Class
#' @importFrom utils modifyList
language <- R6::R6Class(
  classname = "shinymanager_language",
  public = list(
    initialize = function() {
      invisible(self)
    },
    set_language = function(lan) {
      if (!lan %in% private$language_registered) {
        stop("Unsupported language !", call. = FALSE)
      }
      private$language <- lan
      private$labels <-   switch (lan,
                                  "en" = pkgEnv$label_en,
                                  "fr" = pkgEnv$label_fr,
                                  "pt-BR" = pkgEnv$label_ptbr, 
                                  "es" = pkgEnv$label_es,
                                  "de" = pkgEnv$label_de,
                                  "pl" = pkgEnv$label_pl
      )
    },
    get = function(label) {
      value <- private$labels[[label]]
      if(is.null(value)){
        label
      } else {
        value
      }
    },
    get_all = function() {
      private$labels
    },
    get_DT = function() {
      private$DT_lan[[private$language]]
    },
    get_language_registered = function() {
      private$language_registered
    },
    get_language = function() {
      private$language
    }
  ),
  private = list(
    language = "en",
    language_registered = v_language_registered,
    labels = pkgEnv$label_en,
    DT_lan = list(
      fr = list(
        sProcessing = "Traitement en cours...", sSearch = "Rechercher&nbsp;:",
        sLengthMenu = "Afficher _MENU_ &eacute;l&eacute;ments",
        sInfo = "Affichage de l\'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
        sInfoEmpty = "Affichage de l\'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
        sInfoFiltered = "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
        sInfoPostFix = "", sLoadingRecords = "Chargement en cours...",
        sZeroRecords = "Aucun &eacute;l&eacute;ment &agrave; afficher",
        sEmptyTable = "Aucune donn&eacute;e disponible dans le tableau",
        oPaginate = list(
          sFirst = "Premier", sPrevious = "Pr&eacute;c&eacute;dent",
          sNext = "Suivant", sLast = "Dernier"
        ),
        oAria = list(
          sSortAscending = ": activer pour trier la colonne par ordre croissant",
          sSortDescending = ": activer pour trier la colonne par ordre d&eacute;croissant"
        )
      ),
      en = list(
        sEmptyTable = "No data available in table",
        sInfo = "Showing _START_ to _END_ of _TOTAL_ entries",
        sInfoEmpty = "Showing 0 to 0 of 0 entries",
        sInfoFiltered = "(filtered from _MAX_ total entries)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Show _MENU_ entries",
        sLoadingRecords = "Loading...",
        sProcessing = "Processing...",
        sSearch = "Search:",
        sZeroRecords = "No matching records found",
        oPaginate = list(
          sFirst = "First",
          sLast = "Last",
          sNext = "Next",
          sPrevious = "Previous"
        ),
        oAria = list(
          sSortAscending = ": activate to sort column ascending",
          sSortDescending = ": activate to sort column descending"
        )
      ),
      `pt-BR` = list(
        sEmptyTable = "Nenhum dado dispon\u00edvel na tabela",
        sInfo = "Mostrando entrada de _START_ at\u00e9 _END_ de um total de _TOTAL_ entradas",
        sInfoEmpty = "Mostrando entrada de 0 at\u00e9 0 de um total de 0 entradas",
        sInfoFiltered = "(filtrado de um total de _MAX_ entradas)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Mostrar _MENU_ entradas",
        sLoadingRecords = "Carregando...",
        sProcessing = "Processando...",
        sSearch = "Busca:",
        sZeroRecords = "Nenhum registro compat\u00edvel encontrado",
        oPaginate = list(
          sFirst = "Primeiro",
          sLast = "\u00daltimo",
          sNext = "Pr\u00f3ximo",
          sPrevious = "Anterior"
        ),
        oAria = list(
          sSortAscending = ": ativar para ordenar coluna de forma ascendente",
          sSortDescending = ": ativar para ordenar coluna de forma descendente"
        )
      ),
      es = list(
        sEmptyTable = "No se encontraron resultados",
        sInfo = "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty = "Mostrando registros del 0 al 0 de 0 registros",
        sInfoFiltered = "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Mostrar _MENU_ registros",
        sLoadingRecords = "Cargando...",
        sProcessing = "Procesando...",
        sSearch = "Buscar:",
        sZeroRecords = "No se encontraron resultados",
        oPaginate = list(
          sFirst = "Primera",
          sLast = "\u00daltima",
          sNext = "Siguiente",
          sPrevious = "Anterior"
        ),
        oAria = list(
          sSortAscending = ": activar para ordenar la columna de forma ascendente",
          sSortDescending = ": activar para ordenar la columna de forma descendente"
        )
      ),
      de = list(
        sEmptyTable = "Keine Daten in der Tabelle vorhanden",
        sInfo = "Zeige _START_ bis _END_ von _TOTAL_ Eintr\u00e4ge",
        sInfoEmpty = "Zeige 0 bis 0 von 0 Eintr\u00e4ge",
        sInfoFiltered = "(gefiltert von _MAX_ total entries)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Zeige _MENU_ Eintr\u00e4ge",
        sLoadingRecords = "Wird geladen...",
        sProcessing = "Wird verarbeitet...",
        sSearch = "Suche:",
        sZeroRecords = "Keine passenden Eitr\u00e4ge gefunden",
        oPaginate = list(
          sFirst = "Erste",
          sLast = "Letzte",
          sNext = "N\u00e4chste",
          sPrevious = "Zur\u00fcck"
        ),
        oAria = list(
          sSortAscending = ": aktivieren, um Spalte aufsteigend zu sortieren",
          sSortDescending = ": aktivieren, um Spalte absteigend zu sortieren"
        )
      ),
      pl = list(
        sEmptyTable = "Brak danych w tabeli",
        sInfo = "Pokazuje _START_ do _END_ z _TOTAL_ pozycji",
        sInfoEmpty = "Pokazuje 0 do 0 z 0 pozycji",
        sInfoFiltered = "(przefiltrowano z _MAX_ wszystkich pozycji)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Poka\u017C _MENU_ pozycje",
        sLoadingRecords = "\u0141adowanie...",
        sProcessing = "Przetwarzanie...",
        sSearch = "Wyszukaj:",
        sZeroRecords = "Brak pasuj\u0105cych pozycji",
        oPaginate = list(
          sFirst = "Pierwsza",
          sLast = "Ostatnia",
          sNext = "Nast\u0119pna",
          sPrevious = "Poprzednia"
        ),
        oAria = list(
          sSortAscending = ": aktywuj aby sortowa\u0107 wzrastaj\u0105co",
          sSortDescending = ": aktywuj aby sortowa\u0107 zst\u0119puj\u0105co"
        )
      )
    ),
    length = function() base::length(private$labels)
  )
)


#' @title Use {shinymanager} labels
#'
#' @description See all labels registered with \code{get_labels()},
#'  then set custom text with \code{set_labels()}.
#'
#' @param lan Language to use for labels, supported values are : "en", "fr", "pt-BR", "es", "de", "pl".
#'
#' @return A language object
#' @export
#'
#'
#' @examples
#'
#' use_language(lan = "fr")
#' 
use_language <- function(lan = "en") {
  lang <- language$new()
  lang$set_language(lan)
  lang
}

#' @title Modify {shinymanager} labels to use custom text
#'
#' @description See all labels registered with \code{get_labels()},
#'  then set custom text with \code{set_labels()}.
#'
#' @param language Language to use for labels, supported values are : "en", "fr", "pt-BR", "es", "de", "pl".
#' @param ... A named list with labels to replace.
#'
#' @return \code{get_labels()} return a named list with all labels registered.
#' @export
#'
#' @name custom-labels
#'
#' @examples
#'
#' # In global.R for example:
#' set_labels(
#'   language = "en",
#'   "Please authenticate" = "You have to login",
#'   "Username:" = "What's your name:",
#'   "Password:" = "Enter your password:"
#' )
set_labels <- function(language, ...) {
  if (!language %in% c("en", "fr", "pt-BR", "es", "de", "pl")) {
    stop("Only supported language for the now are: en, fr, pt-BR, es, de, pl", call. = FALSE)
  }
  args <- list(...)
  if (!all(nzchar(names(args)))) {
    stop("All arguments must be named!", call. = FALSE)
  }

  current_labels <- switch (language,
                   "en" = pkgEnv$label_en,
                   "fr" = pkgEnv$label_fr,
                   "pt-BR" = pkgEnv$label_ptbr,
                   "es" = pkgEnv$label_es,
                   "de" = pkgEnv$label_de,
                   "pl" = pkgEnv$label_pl
  )

  update_labels <- modifyList(
    x = current_labels,
    val = lapply(args, I)
  )

  if(language %in% "en"){
    pkgEnv$label_en <- update_labels
  } else if(language %in% "fr"){
    pkgEnv$label_fr <- update_labels
  } else if(language %in% "pt-BR"){
    pkgEnv$label_ptbr <- update_labels
  } else if(language %in% "es"){
    pkgEnv$label_es <- update_labels
  } else if(language %in% "de"){
    pkgEnv$label_de <- update_labels
  } else if(language %in% "pl"){
    pkgEnv$label_pl <- update_labels
  }

  invisible(TRUE)
}

#' @export
#'
#' @rdname custom-labels
get_labels <- function(language = "en") {
  if (!language %in% c("en", "fr", "pt-BR", "es", "de", "pl")) {
    warning("Only supported language for the now are: en, fr, pt-BR, es, de, pl", call. = FALSE)
    language <- "en"
  }

  switch (language,
          "en" = pkgEnv$label_en,
          "fr" = pkgEnv$label_fr,
          "pt-BR" = pkgEnv$label_ptbr,
          "es" = pkgEnv$label_es,
          "de" = pkgEnv$label_de,
          "pl" = pkgEnv$label_pl
  )
}



