% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoreline_date.R
\name{shoreline_date}
\alias{shoreline_date}
\title{Shoreline date}
\usage{
shoreline_date(
  sites,
  elevation = NA,
  elev_reso = 0.01,
  cal_reso = 10,
  isobase_direction = 327,
  sum_isobase_directions = FALSE,
  model = "gamma",
  model_parameters = c(0.286, 20.833),
  elev_fun = "mean",
  interpolated_curve = NA,
  hdr_prob = 0.95,
  normalise = TRUE,
  sparse = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{sites}{Vector giving one or more site names, or, if displacement curves
are to be interpolated, objects of class \code{sf} representing the sites to be
dated. In the case of a spatial geometry, the first column is taken as the
site name.}

\item{elevation}{Vector of numeric elevation values for each site or a
an elevation raster of class \code{SpatRaster} from the package
\code{terra} from where the elevation values are to be derived.}

\item{elev_reso}{Numeric value specifying the resolution with which to step
through the distribution representing the distance between site and
shoreline. Defaults to 0.01m.}

\item{cal_reso}{Numeric value specifying the resolution to use on the
calendar scale. Defaults to 10.}

\item{isobase_direction}{A vector of numeric values defining the direction(s)
of the isobases. Defaults to 327.}

\item{sum_isobase_directions}{Logical value indicating that if multiple
isobase directions are specified in \code{isobase_direction} the results should
be summed for each site using \code{sum_shoredates}. Defaults to FALSE.}

\item{model}{Character vector specifying the statistical model with which to
model the distance from site to shoreline. Currently accepts either "none"
or "gamma". Defaults to "gamma".}

\item{model_parameters}{Vector of numeric values specifying the parameters
for the statistical model describing the distance between site and
shoreline. Defaults to c(0.286, 20.833), denoting the shape and scale of the
default gamma function, respectively.}

\item{elev_fun}{Statistic to define site elevation if this is to be derived
from an elevation raster. Uses \code{terra::extract()}. Defaults to mean.}

\item{interpolated_curve}{List holding precomputed shoreline displacement
curve. This has to have the same resolution on the calendar scale as the one
specified with \code{cal_reso}. \code{\link[=interpolate_curve]{interpolate_curve()}} will be run if this is not
provided.}

\item{hdr_prob}{Numeric value specifying the coverage of the highest density
region. Defaults to 0.95.}

\item{normalise}{Logical value specifying whether the shoreline date should
be normalised to sum to unity. Defaults to TRUE.}

\item{sparse}{Logical value specifying if only site name and shoreline date
should be returned. Defaults to FALSE. Note that of the functions for
further treatment, sparse dates are only compatible with
\code{\link[=sum_shoredates]{sum_shoredates()}}.}

\item{verbose}{Logical value indicating whether progress should be printed to
console. Defaults to FALSE.}
}
\value{
A nested list of class \code{shoreline_date} holding the shoreline date
results and associated metadata for each dated site for each isobase
direction. The elements of each date is:
\itemize{
\item \code{site_name} name of the site.
\item \code{site_elev} elevation of the site.
\item \code{date} data frame with the columns \code{bce} where negative values
indicate years BCE and positive CE, as well as \code{probability}, which gives
the probability mass for each year.
\item \code{weighted_mean} the weighted mean date.
\item \code{hdr_start} start values for the HDR ranges.
\item \code{hdr_end} end values for the HDR ranges.
\item \code{hdr_prob} probability level for the HDR.
\item \code{dispcurve} data frame holding the displacement curve used for dating
the site. This has the columns \code{bce}, giving years BCE/CE. \code{lowerelev},
the lower limit for the elevation of the shoreline for each year.
\code{upperelev}, the upper limit for elevation of the shoreline for each year.
\item \code{dispcurve_direction} direction of the isobases in use.
\item \code{model_parameters} parameters for the statistical model.
\item \code{modeldat} data frame holding the model distribution. The column
\code{offset} denotes the vertical distance (m) from the shoreline, as specified
by the \code{elev_reso} argument. \code{px} is the cumulative probability at each step
of \code{offset}, and \code{probs} is the probability of each step found by
subtracting the preceding value from each value of \code{px}.
\item \code{cal_reso} resolution on the calendar scale.
}
}
\description{
A function for shoreline dating Stone Age sites based on their present-day
elevation, their likely elevation above sea-level when in use and the
trajectory of past shoreline displacement on the Norwegian Skagerrak coast.
Details and caveats pertaining to the implemented method is given in
Roalkvam (2023).
}
\examples{
# Create example point using the required CRS WGS84 UTM32N (EPSG: 32632)
target_point <- sf::st_sfc(sf::st_point(c(538310, 6544255)), crs = 32632)

# Date target point, manually specifying the elevation instead of providing
# an elevation raster. Reducing elev_reso and cal_reso for speed.
shoreline_date(sites = target_point,
               elevation = 80,
               elev_reso = 1,
               cal_reso = 400)
}
\references{
Roalkvam, I. 2023. A simulation-based assessment of the relation between
Stone Age sites and relative sea-level change along the Norwegian Skagerrak
coast. \emph{Quaternary Science Reviews} 299:107880. DOI:
https://doi.org/10.1016/j.quascirev.2022.107880
}
