% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.shrink.R
\name{predict.shrink}
\alias{predict.shrink}
\title{Predict Method for Objects of Class \code{shrink}}
\usage{
\method{predict}{shrink}(object, newdata = NULL, type = c("link",
  "response", "lp", "risk", "expected", "terms"), shrinktype = NULL,
  terms = NULL, na.action = na.pass, collapse, safe = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{shrink}.}

\item{newdata}{a data frame for which predictions are obtained, otherwise
predictions are based on the data stored in \code{object}.}

\item{type}{the type of prediction required.}

\item{shrinktype}{the type of shrinkage requested, if the \code{object} was
obtained with \code{type = "all"}, either \code{"parameterwise"} or
\code{"global"}.}

\item{terms}{with \code{type = "terms"} by default all terms are returned. A
character vector specifies which terms are to be returned.}

\item{na.action}{function determining what should be done with missing values
in \code{newdata}. The default is to include all observations.}

\item{collapse}{if \code{family = coxph} or \code{Cox}, an optional vector of
subject identifiers. If specified, the output will contain one entry per
subject rather than one entry per observation.}

\item{safe}{option from \code{predict.mfp}.}

\item{...}{additional arguments to be passed to methods.}
}
\value{
A vector or matrix of predictions.
}
\description{
Obtains predictions from shrunken regression coefficients from an object of
class \code{shrink}.
This class of objects is returned by the \code{shrink} function. Objects of this
class have methods for the functions \code{coef}, \code{predict}, \code{print},
\code{summary}, and \code{vcov}.
}
\note{
If \code{object} was obtained using \code{type = "all"}, \code{shrinktype}
      specifies for which type of shrinkage predictions are requested.
      \code{shrinktype} will be ignored if \code{object} was obtained using
      either \code{type = "parameterwise"} or \code{type = "global"}.
}
\examples{
data("GBSG")
library("mfp")

fit <- mfp(Surv(rfst, cens) ~ fp(age, df = 4, select = 0.05) +
           fp(prm, df = 4, select = 0.05), family = cox, data = GBSG)

dfbeta.global <- shrink(fit, type = "global",  method = "dfbeta")
dfbeta.pw     <- shrink(fit, type = "parameterwise", method = "dfbeta")
dfbeta.join   <- shrink(fit, type = "parameterwise", method = "dfbeta",
                        join=list(c("age.1", "age.2")))

age <- 30:80
newdat <- data.frame(age = age, prm = 0)
refdat <- data.frame(age = 50, prm = 0)

# unshrunken
plot(age, predict(fit, newdata = newdat, type = "lp") -
       predict(fit, newdata = refdat, type = "lp"), xlab = "Age",
     ylab = "Log hazard relative to 50 years", type = "l", lwd = 2)

# globally shrunken
lines(age, predict(dfbeta.global,newdata = newdat, type = "lp") -
        predict(dfbeta.global, newdata = refdat, type = "lp"), lty = 3, col = "red", lwd = 2)

# jointly shrunken
lines(age, predict(dfbeta.join, newdata = newdat, type = "lp") -
        predict(dfbeta.join, newdata = refdat, type = "lp"), lty = 4, col = "blue", lwd = 2)

# parameterwise shrunken
lines(age, predict(dfbeta.pw, newdata = newdat, type = "lp") -
        predict(dfbeta.pw, newdata =refdat, type = "lp"), lty = 2, col = "green", lwd = 2)

legend("topright", lty = c(1, 3, 4, 2), title = "SHRINKAGE",
       legend = c("No", "Global", "Joint", "Parameterwise"), inset = 0.01, bty = "n",
       col = c("black", "red", "blue", "green"), lwd = 2)
}
\seealso{
\code{\link{shrink}}, \code{\link{coef.shrink}}, \code{\link{print.shrink}},
    \code{\link{summary.shrink}}, \code{\link{vcov.shrink}}
}

