% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrink.glm.R
\name{shrink.glm}
\alias{shrink.glm}
\title{Global, Parameterwise and Joint Shrinkage of Regression Coefficients for Fit Object's of Class \code{glm}.}
\usage{
shrink.glm(fit, type, method, join, notes, postfit)
}
\arguments{
\item{fit}{a fit object of class \code{lm}, \code{glm}, \code{coxph}, or \code{mfp}.
The fit object must have been called with \code{x = TRUE} (and
\code{y = TRUE} in case of class \code{lm}).}

\item{type}{of shrinkage, either \code{"parameterwise"} (default), \code{"global"}
shrinkage, or \code{"all"}.}

\item{method}{of shrinkage estimation, either \code{"jackknife"} (based on
leave-one-out resampling, default) or \code{"dfbeta"} (excellent approximation
based on DFBETA residuals).}

\item{join}{compute optional joint shrinkage factors for sets of specified columns
of the design matrix, if \code{type =} \code{"parameterwise"}. See details.}

\item{notes}{print notes. Default is TRUE.}

\item{postfit}{obtain fit with shrunken regression coefficients. This option
is only available for models without an intercept. Default is TRUE.}
}
\value{
A list with the following elements:
\tabular{ll}{
    ShrinkageFactors \tab cdot[rmInt] \cr
    ShrinkageFactorsVCOV \tab summary.glm(sfit)$cov.scaled \cr
    ShrunkenRegCoef \tab shcoef \cr
    postfit \tab pfit \cr
}
}
\description{
Internal function for \code{shrink}.
}
\keyword{internal}

