% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_fit_bootstrap_batch.R
\name{sig_fit_bootstrap_batch}
\alias{sig_fit_bootstrap_batch}
\title{Exposure Instability Analysis of Signature Exposures with Bootstrap}
\usage{
sig_fit_bootstrap_batch(
  catalogue_matrix,
  methods = c("LS", "QP"),
  n = 100L,
  p_val_thresholds = c(0.05),
  use_parallel = FALSE,
  seed = 123456L,
  ...
)
}
\arguments{
\item{catalogue_matrix}{a numeric matrix \code{V} with row representing components and
columns representing samples, typically you can get \code{nmf_matrix} from \code{sig_tally()} and
transpose it by \code{t()}.}

\item{methods}{a subset of \code{c("LS", "QP", "SA")}.}

\item{n}{the number of bootstrap replicates.}

\item{p_val_thresholds}{a vector of relative exposure threshold for calculating p values.}

\item{use_parallel}{if \code{TRUE}, use parallel computation based on \strong{furrr} package,
not implemented yet.}

\item{seed}{random seed to reproduce the result.}

\item{...}{other common parameters passing to \link{sig_fit_bootstrap}, including \code{sig}, \code{sig_index},
\code{sig_db}, \code{db_type}, \code{mode}, etc.}
}
\value{
a \code{list} of \code{data.table}.
}
\description{
Exposure Instability Analysis of Signature Exposures with Bootstrap
}
\examples{
W <- matrix(c(1, 2, 3, 4, 5, 6), ncol = 2)
colnames(W) <- c("sig1", "sig2")
W <- apply(W, 2, function(x) x / sum(x))

H <- matrix(c(2, 5, 3, 6, 1, 9, 1, 2), ncol = 4)
colnames(H) <- paste0("samp", 1:4)

V <- W \%*\% H
V

if (requireNamespace("lsei") & requireNamespace("quadprog")) {
  z <- sig_fit_bootstrap_batch(V, sig = W, n = 2)
  z
  z10 <- sig_fit_bootstrap_batch(V, sig = W, n = 10)
}
}
\seealso{
\link{sig_fit}, \link{sig_fit_bootstrap}
}
