% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomTest.R
\name{wrapBinomTest.numeric}
\alias{wrapBinomTest.numeric}
\title{Wrap binom.test (test of Binomial/Bernoulli rate).}
\usage{
\method{wrapBinomTest}{numeric}(x, SuccessValue, ..., p = NA,
  alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
  na.rm = FALSE)
}
\arguments{
\item{x}{numeric, vector of trials.}

\item{SuccessValue}{value considered a success (positive)}

\item{...}{extra arguments passed to binom.test}

\item{p}{number, hypothesized probability of success.}

\item{alternative}{passed to \code{\link[stats]{binom.test}}}

\item{conf.level}{passed to \code{\link[stats]{binom.test}}}

\item{na.rm}{logical, if TRUE remove NA values}
}
\value{
wrapped stat
}
\description{
Wrap binom.test (test of Binomial/Bernoulli rate).
}
\examples{

x = c(rep(0, 3), rep(1, 7))
wrapBinomTest(x, 1)
x = c(rep(0, 15), rep(1, 35))
wrapBinomTest(x, 1)


}
\seealso{
\code{\link{wrapBinomTest}}, \code{\link{wrapBinomTest.htest}}, \code{\link{wrapBinomTestS}}, \code{\link{wrapBinomTest.logical}}, \code{\link{wrapBinomTest.numeric}}, \code{\link{wrapBinomTest.data.frame}}
}
