% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silicate-package.R
\docType{data}
\name{inlandwaters}
\alias{inlandwaters}
\title{Inland waters, for parts of Australia, and New Caledonia.}
\description{
The inland waters are lakes and inland waters presenting as holes
within the bounded regions of Australian (and New Caledonian) provinces.
}
\details{
This is an extract from the old Manifold DVD. It is in \code{sf} format\code{. The features have variables }ID\code{and}Province` they are (in order):
\itemize{
\item{"103841"}{Australian Capital Territory}
\item{"103842"}{New Caledonia}
\item{"103843"}{New South Wales}
\item{"103846"}{South Australia}
\item{"103847"}{Tasmania}
\item{"103848"}{Victoria}
}
There's no good reason that New Caledonia is included and not Queensland (for example)
it's just what happened doing a quick crop and extract with the mouse. Lord Howe Island and
Macquarie Island are both present, as part of New South Wales and Tasmania respectively.
}
\examples{
\donttest{
path <- PATH(inlandwaters)
plot(path)
obj <- split(path$path_link_vertex, path$path_link_vertex$path_)
cl <- grDevices::colors()[-1L]
cols <- sample(cl, length(obj), replace = length(obj) > length(cl))
op <- par(mfrow = grDevices::n2mfrow(length(obj)), mar = rep(0, 4))
funplot <- function(ob, vert, col) {
vx <- c("x_", "y_")
  plot(dplyr::inner_join(ob, vert, "vertex_")[vx], col = col, type = "l", axes = FALSE)
  }
junk <- lapply(seq_along(obj),
function(a) {
  funplot(obj[[a]], path$vertex, cols[a])
  invisible(NULL)
  })
  par(op)
 }
}
