% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{newFamily3generations}
\alias{newFamily3generations}
\title{Generates genotype data for a family of 3 generations}
\usage{
newFamily3generations(familyid, noffspring2 = 2, noffspring3 = c(1, 1))
}
\arguments{
\item{familyid}{What will be the family_id (for example: 100)}

\item{noffspring2}{Number of offspring in generation 2}

\item{noffspring3}{Number of offspring in generation 3 (vector of length noffspring2)}
}
\value{
family structure object
}
\description{
Generates genotype data for a family of 3 generations
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = file.path(examples_dir, "region.vcf.gz")
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
               min_maf = 0.12 ,max_maf = NA)

generateUniformGeneticMap()

startSimulation(vcf, totalNumberOfIndividuals = 200)

ped_line = newFamily3generations(12, 3, c(3,3,2) )
}
