% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupGaussianParameters.R
\name{calculate_stats_gaussian}
\alias{calculate_stats_gaussian}
\title{Calculate summary statistics for each group}
\usage{
calculate_stats_gaussian(data_df, group_col)
}
\arguments{
\item{data_df}{A data frame containing the data to be processed.}

\item{group_col}{A character string specifying the name of the column to
group by.}
}
\value{
A list of lists, where each inner list contains the following
parameter estimates for one group:
\itemize{
\item sample size (\code{sampSize})
\item sample mean vector (\code{xBar})
\item sample standard deviation vector (\code{sampSD})
\item sample Spearman correlation matrix (\code{sampCorr_mat})
\item sample skewness (\code{sampSkew})
}
}
\description{
This function computes the sample size, mean vector, standard
deviation vector, Spearman correlation matrix, and skewness vector for each
group, based on the grouping column.
}
\examples{
myData <- data.frame(
  GENDER = c('Male', 'Female', 'Male', 'Female', 'Male', 'Female'),
  VALUE1 = c(1.2, 2.3, 1.5, 2.7, 1.35, 2.5),
  VALUE2 = c(3.4, 4.5, 3.8, 4.2, 3.6, 4.35)
)
calculate_stats_gaussian(myData, "GENDER")
}
