% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queuePlotting.R
\name{defaultPlotSkyline}
\alias{defaultPlotSkyline}
\title{Default Skyline Plotting Function}
\usage{
defaultPlotSkyline(
  times,
  numsInSys,
  numsInQue,
  numsInSvr,
  rangePlot,
  rangeAll,
  show,
  title = ""
)
}
\arguments{
\item{times}{Vector of times at which statistics were recorded (x-values)}

\item{numsInSys}{Number of jobs in the system at a given time, corresponding
to provided times.}

\item{numsInQue}{Number of jobs in the queue at a given time, corresponding
to provided times.}

\item{numsInSvr}{Number of the next job that will enter the queue.}

\item{rangePlot}{Range/subset of data to plot (vector of min and max)}

\item{rangeAll}{Range of all of the data (vector of min and max)}

\item{show}{A vector of 3 logicals that specifies to show number in
system, queue, and server, respectively.}

\item{title}{Title of the plot}
}
\description{
This function plots a visualization of a queue's skyline (number
   of jobs in system, queue, and server) based on inputted statistics.
}
\details{
Generates a snapshot skyline plot and is the default plotting function for
   \code{ssq} and \code{msq}.
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{queueing}
\keyword{internal}
