% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_orivisit.R
\name{orivisit}
\alias{orivisit}
\title{create orivisit object}
\usage{
orivisit(df_visit, call = NULL, env = parent.frame(), event_names = c("ae"))
}
\arguments{
\item{df_visit}{dataframe with original visit data}

\item{call}{optional, provide call, Default: NULL}

\item{env}{optional, provide environment of original visit data, Default: parent.frame()}

\item{event_names}{vector, contains the event names, default = "ae"}
}
\value{
orivisit object
}
\description{
Internal S3 object, stores lazy reference to original visit
data.
}
\details{
Saves variable name of original visit data, checks whether it can be
retrieved from parent environment and stores summary. Original data can be
retrieved using as.data.frame(x).
}
\examples{

df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  frac_site_with_ur = 0.4,
  ur_rate = 0.6
)

df_visit$study_id <- "A"

visit <- orivisit(df_visit)

object.size(df_visit)
object.size(visit)

as.data.frame(visit)

}
