% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.r
\name{DF.to.longDT}
\alias{DF.to.longDT}
\title{Faster Conversion of Data from Wide to Long Format Using \code{dcast.data.table}}
\usage{
DF.to.longDT(df_wide, return_DF = TRUE)
}
\arguments{
\item{df_wide}{A \code{data.frame} or \code{data.table} in wide format}

\item{return_DF}{\code{TRUE} (default) to return a \code{data.frame}, \code{FALSE} returns a \code{data.table}}
}
\value{
A \code{data.frame} in long format
}
\description{
Faster utility function for converting wide-format \code{data.frame} into a long format.
Internally uses \pkg{data.table} package functions \code{melt.data.table} and \code{dcast.data.table}.
}
\details{
Keeps all covariates that appear only once and at the first time-point constant (carry-forward).

All covariates that appear fewer than range(t) times are imputed with NA for missing time-points.

Observations with all NA's for all time-varying covariates are removed.

When removing NA's the time-varying covariates that are attributes (attnames) are not considered.
}
\seealso{
Other data manipulation functions: \code{\link{DF.to.long}},
  \code{\link{doLTCF}}
}
