% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_relative_var.R
\name{calc_relative_var}
\alias{calc_relative_var}
\title{Calculate jack-knife Monte Carlo SE for variance estimators}
\usage{
calc_relative_var(
  data,
  estimates,
  var_estimates,
  criteria = c("relative bias", "relative mse", "relative rmse")
)
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{estimates}{Vector or name of column from \code{data} containing point estimates.}

\item{var_estimates}{Vector or name of column from \code{data} containing variance estimates for point estimator in \code{estimates}.}

\item{criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates relative bias, mean squared error (relative mse), and root mean
squared error (relative rmse)  of variance estimators.
The function also calculates the associated jack-knife Monte Carlo standard errors.
}
\examples{
calc_relative_var(data = alpha_res, estimates = A, var_estimates = Var_A)

}
