% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{timeout}
\alias{timeout}
\alias{timeout_from_attribute}
\alias{timeout_from_global}
\title{Delay}
\usage{
timeout(.trj, task)

timeout_from_attribute(.trj, key)

timeout_from_global(.trj, key)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{task}{the timeout duration supplied by either passing a numeric or a
callable object (a function) which must return a numeric (negative values are
automatically coerced to positive).}

\item{key}{the attribute name, or a callable object (a function) which
must return the attribute name.}
}
\value{
Returns the trajectory object.
}
\description{
Activity for inserting delays and execute user-defined tasks.
}
\examples{
env <- simmer()

traj <- trajectory() \%>\%

  # static delay
  timeout(3) \%>\%

  # dynamic, exponential delay
  timeout(function() rexp(1, 10)) \%>\%

  # dependent on an attribute
  set_attribute("delay", 2) \%>\%
  set_global("other", function() rexp(1, 2)) \%>\%
  timeout_from_attribute("delay") \%>\%
  timeout_from_global("other")

env \%>\%
  add_generator("dummy", traj, at(0)) \%>\%
  run() \%>\%
  get_mon_arrivals()

}
\seealso{
\code{\link{set_attribute}}, \code{\link{set_global}}

\code{\link{set_attribute}}, \code{\link{set_global}}
}
