% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.simmr_output_tdf.R
\name{summary.simmr_output_tdf}
\alias{summary.simmr_output_tdf}
\title{Summarises the output created with \code{\link{simmr_mcmc_tdf}}}
\usage{
\method{summary}{simmr_output_tdf}(
  object,
  type = c("diagnostics", "quantiles", "statistics", "correlations"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{simmr_output_df} produced by the
function \code{\link{simmr_mcmc_tdf}}}

\item{type}{The type of output required. At least none of 'diagnostics',
'quantiles', 'statistics', 'correlations'}

\item{...}{Not used}
}
\value{
An list containing the following components: \item{gelman }{The
convergence diagnostics} \item{quantiles }{The quantiles of each parameter
from the posterior distribution} \item{statistics }{The means and standard
deviations of each parameter} \item{correlations }{The posterior
correlations between the parameters} Note that this object is reported
silently so will be discarded unless the function is called with an object
as in the example below.
}
\description{
Produces textual summaries and convergence diagnostics for an object created
with \code{\link{simmr_mcmc_tdf}}. The different options are: 'diagnostics'
which produces Brooks-Gelman-Rubin diagnostics to assess MCMC convergence,
'quantiles' which produces credible intervals for the parameters,
'statistics' which produces means and standard deviations, and
'correlations' which produces correlations between the parameters.
}
\details{
The quantile output allows easy calculation of 95 per cent credible
intervals of the posterior dietary proportions. The Gelman diagnostic values should be close to 1 to ensure satisfactory convergence.

Multiple groups are not currently supported for estimating TDFs.
}
\seealso{
See \code{\link{simmr_mcmc_tdf}} for creating objects suitable for this
function, and many more examples. See also \code{\link{simmr_load}} for
creating simmr objects, \code{\link{plot.simmr_input}} for creating isospace
plots, \code{\link{plot.simmr_output}} for plotting output.
}
\author{
Andrew Parnell <andrew.parnell@mu.ie>
}
