% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{setAllSimulationValues}
\alias{setAllSimulationValues}
\title{Changes values of the all simulations in queue}
\usage{
setAllSimulationValues(simplace, parameterLists = NULL)
}
\arguments{
\item{simplace}{handle to the SimplaceWrapper object returned by \code{\link{initSimplace}}}

\item{parameterLists}{a list of parameter lists for each simulation}
}
\value{
No return value, called for the side effect of changing parameters in all simulations
}
\description{
Sets values of arbitrary SimVariables in a simplace simulation.
Useful if you want to couple simplace with another simulation 
and interchange values daily.
}
\examples{
\dontrun{
for(i in 1:365)
{
  params <- list()
  params[[1]] <- list(vBaseLUE=3.0 + i/2000)
  params[[2]] <- list(vBaseLUE=3.0 - i/2000)
  setAllSimulationValues(simplace,params)
  stepAllSimulations(simplace)
}
}

}
