% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_sf.R
\name{leaflet_sf_col}
\alias{leaflet_sf_col}
\title{Simple feature leaflet map that is coloured.}
\usage{
leaflet_sf_col(
  data,
  col_var,
  label_var = NULL,
  popup_vars_vctr = NULL,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  size_point = 2,
  size_line = 2,
  alpha = NULL,
  basemap = "light",
  col_cuts = NULL,
  col_label_digits = NULL,
  col_labels = NULL,
  col_method = NULL,
  col_na_rm = FALSE,
  col_pretty_n = 4,
  col_right_closed = TRUE,
  col_title = NULL,
  map_id = "map"
)
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{col_var}{Unquoted variable to colour the features by. Required input.}

\item{label_var}{Unquoted variable to label the features by. If NULL, defaults to using the colour variable.}

\item{popup_vars_vctr}{Vector of quoted variable names to include in the popup. If NULL, defaults to making a leafpop::popupTable of all columns.}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{size_point}{Size of points (i.e. radius). Defaults to 2.}

\item{size_line}{Size of lines around features (i.e. weight). Defaults to 2.}

\item{alpha}{The opacity of features. Defaults to 1 for points/lines, or 0.95 for polygons.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_label_digits}{If numeric colour method, the number of digits to round the labels to.}

\item{col_labels}{A vector to modify colour scale labels.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." If numeric, defaults to "bin".}

\item{col_na_rm}{TRUE or FALSE of whether to include col_var NA values. Defaults to FALSE.}

\item{col_pretty_n}{For a numeric colour variable of "bin" col_method, the desired number of intervals on the colour scale, as calculated by the pretty algorithm. Defaults to 4.}

\item{col_right_closed}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut right-closed. Defaults to TRUE.}

\item{col_title}{A title string that will be wrapped into the legend.}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. For standard single-map apps, id "map" should be used. For dual-map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is coloured.
}
\examples{
leaflet_sf_col(example_sf_point, 
               col_var = trend_category)

leaflet_sf_col(example_sf_polygon, 
               col_var = density, 
               col_method = "quantile", 
               col_cuts = c(0, 0.25, 0.5, 0.75, 0.95, 1))

leaflet_sf_col(example_sf_polygon, 
               col_var = density, 
               col_method = "bin", 
               col_cuts = c(0, 10, 50, 100, 150, 200, Inf))

}
