% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval_type_1_err.R
\name{pval_type_1_err}
\alias{pval_type_1_err}
\title{Estimate type I error rate}
\usage{
pval_type_1_err(pvals, causal_indexes, alpha = 0.05)
}
\arguments{
\item{pvals}{The vector of association p-values to analyze.
This function assumes all p-values are provided (a mix of null and alternative tests).
\code{NA} values are allowed in input and removed.
Non-\code{NA} values outside of [0, 1] will trigger an error.}

\item{causal_indexes}{The vector of causal indexes, whose p-values will be omitted.
Values of \code{causal_indexes} as returned by \code{sim_trait} work.
This parameter is required to prevent use of this function except when the true status of every test (null vs alternative) is known.
Set to \code{NULL} if all loci are truly null (non-causal).
Otherwise, \code{causal_indexes} must have at least one causal index.}

\item{alpha}{The desired significance level (default 0.05).
May be a vector.}
}
\value{
The type I error rate estimates at each \code{alpha}
}
\description{
Given a significance level and p-values with known causal status, this function estimates the type I error rate, defined as the proportion of null p-values that are below or equal to the threshold.
Note that these simple empirical estimates are likely to be zero unless the number of p-values is much larger than \code{1/alpha}.
}
\examples{
# simulate truly null p-values, which should be uniform
pvals <- runif(10)
# for toy example, take the first p-value to be truly causal (will be ignored below)
causal_indexes <- 1
# estimate desired measure
pval_type_1_err( pvals, causal_indexes )

}
\seealso{
\code{\link[=pval_srmsd]{pval_srmsd()}} to directly quantify null p-value uniformity, a more robust alternative to type I error rate.

\code{\link[=pval_infl]{pval_infl()}} for the more traditional inflation factor, which focuses on the median of the full distribution (combination of causal and null cases).
}
