% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitsimts.R
\name{evaluate}
\alias{evaluate}
\title{Evalute a time series or a list of time series models}
\usage{
evaluate(
  models,
  Xt,
  criterion = "IC",
  start = 0.8,
  demean = TRUE,
  print = TRUE
)
}
\arguments{
\item{models}{A time series model or a list of time series models.}

\item{Xt}{A time series (i.e gts object).}

\item{criterion}{Either "IC" for AIC, BIC and HQ or "MAPE" for MAPE.}

\item{start}{A \code{numeric} indicating the starting proportion of the data that 
is used for prediction (assuming criterion = "MAPE").}

\item{demean}{A \code{boolean} indicating whether the model includes a mean / intercept term or not.}

\item{print}{logical. If \code{TRUE} (the default) results are printed.}
}
\value{
AIC, BIC and HQ or MAPE
}
\description{
This function calculates AIC, BIC and HQ or the MAPE for a list of time series
models. This function currently only supports models estimated by the MLE.
}
\examples{
set.seed(18)
n = 300
Xt = gen_gts(n, AR(phi = c(0, 0, 0.8), sigma2 = 1))
evaluate(AR(1), Xt)
evaluate(list(AR(1), AR(3), MA(3), ARMA(1,2), 
SARIMA(ar = 1, i = 0, ma = 1, sar = 1, si = 1, sma = 1, s = 12)), Xt)
evaluate(list(AR(1), AR(3)), Xt, criterion = "MAPE")
}
\author{
Stéphane Guerrier
}
