% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messy_linelist.R
\name{messy_linelist}
\alias{messy_linelist}
\title{Create messy line list data}
\usage{
messy_linelist(linelist, ...)
}
\arguments{
\item{linelist}{Line list \verb{<data.frame>} output from \code{\link[=sim_linelist]{sim_linelist()}}.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Named elements to replace
default settings. Only if names match exactly are elements replaced,
otherwise the function errors.

Accepted arguments and their defaults are:

\describe{
\item{\code{prop_missing}}{A \code{numeric} between 0 and 1 for the proportion of
missing values introduced. Default is \code{0.1} (10\%).
}
\item{\code{missing_value}}{A single atomic \R object used to represent missing
values. Default is \code{NA}.}
\item{\code{prop_spelling_mistakes}}{A \code{numeric} between 0 and 1 used to
specify the proportion of spelling mistakes in \code{character} columns.
Default is \code{0.1} (10\%).
}
\item{\code{inconsistent_sex}}{A \code{logical} boolean to specify whether the
\verb{$sex} column uses \code{"m"} and \code{"f"}, or inconsistently uses \code{"m"}, \code{"f"},
\code{"M"}, \code{"F"}, \code{"male"}, \code{"female"}, \code{"Male"} or \code{"Female"}. Default
is \code{TRUE} so sexes are sampled from the options.}
\item{\code{sex_as_numeric}}{A \code{logical} boolean used to specify whether
the values in the \verb{$sex} column should be encoded as \code{numeric}
values (\code{0} and \code{1}). Default is \code{FALSE}. \code{sex_as_numeric} cannot be
\code{TRUE} if \code{inconsistent_sex = TRUE}.}
\item{\code{numeric_as_char}}{A \code{logical} boolean used to specify whether
\code{numeric} columns should be coerced to \code{character}. Default is \code{TRUE}.}
\item{\code{date_as_char}}{A \code{logical} boolean used to specify whether \code{Date}
columns should be coerced to \code{character}. Default is \code{TRUE}.}
\item{\code{inconsistent_dates}}{A \code{logical} boolean used to specify whether
the values in \code{Date} columns are inconsistently formatted (e.g.
\code{"\%Y-\%m-\%d"}, \code{"\%Y/\%m/\%d"}, \code{"\%d-\%m-\%Y"}, or \code{"\%d \%B \%Y"}).
Default is \code{FALSE}.}
\item{\code{prop_int_as_word}}{A \code{numeric} between 0 and 1 for the proportion
of elements in \code{integer} columns should that are coerced to \code{words} (see
\code{\link[english:words]{english::words()}}). Default is \code{0.5} (50\%).
}
\item{\code{prop_duplicate_row}}{A \code{numeric} between 0 and 1 for the
proportion of rows to duplicate. Default is \code{0.01} (1\%). If
\code{prop_duplicate_row} > 0 then it is guaranteed that at least one row will
be duplicated.}
\item{\code{inconsistent_id}}{A \code{logical} boolean used to specify whether the
\verb{$id} column has inconsistent formatting by appending random prefixes and
suffixes to a random sample (~10\%) of IDs. Default is \code{FALSE}, so IDs
are numbers (\code{numeric}, \code{characters} or words depending on
\code{prop_int_as_word} and \code{numeric_as_char}).}
}}
}
\value{
A messy line list \verb{<data.frame>}.
}
\description{
Take line list output from \code{\link[=sim_linelist]{sim_linelist()}} and replace elements of
the \verb{<data.frame>} with missing values (e.g. \code{NA}), introduce spelling
mistakes and inconsistencies, as well as coerce date types.
}
\details{
By default \code{messy_linelist()}:
\itemize{
\item Introduces 10\% of values missing, i.e. converts to \code{NA}.
\item Introduces spelling mistakes in 10\% of \code{character} columns.
\item Introduce inconsistency in the reporting of \verb{$sex}.
\item Converts \code{numeric} columns (\code{double} & \code{integer}) to \code{character}.
\item Converts \code{Date} columns to \code{character}.
\item Converts 50\% of \code{integer}s to (English) words.
\item Duplicates 1\% of rows.
}

Setting \code{missing_value} to something other than \code{NA} will likely cause
type coercion in the line list \verb{<data.frame>} columns, most likely to
\code{character}.

When setting \code{sex_as_numeric} to \code{TRUE}, male is set to \code{0} and female
to \code{1}. Only one of \code{inconsistent_sex} or \code{sex_as_numeric} can be \code{TRUE},
otherwise the function will error.

If \code{numeric_as_char = TRUE} and \code{sex_as_numeric = TRUE} then the sex encoded
as 0 or 1 is converted to \code{character}. If \code{prop_spelling_mistake} > 0 and
\code{numeric_as_char = TRUE} the columns that are converted from \code{numeric} to
\code{character} do not have spelling mistakes introduced, because they are
numeric characters stored as character strings. If
\code{prop_spelling_mistake} > 0 and \code{date_as_char = TRUE} spelling mistakes are
not introduced into dates.

The \code{Date} columns can be converted into an inconsistent format by
setting \code{inconsistent_dates = TRUE} and it requires \code{date_as_char = TRUE},
if the latter is \code{FALSE} the function will error.

If \code{numeric_as_char = FALSE} and \code{prop_int_as_word} > 0 then the integer
columns are converted to \code{character} string (either \code{character} numbers or
words) but the other \code{numeric} columns are not coerced. Spelling mistakes
are not introduced into integers converted to words when
\code{prop_spelling_mistakes} > 0 and \code{prop_int_as_word} > 0.

Rows are duplicated after other \emph{messy} modifications so the duplicated row
contains identical \emph{messy} elements.
}
\examples{
linelist <- sim_linelist()
messy_linelist <- messy_linelist(linelist)

# increasing proportion of missingness to 30\% with a missing value of -99
messy_linelist <- messy_linelist(
  linelist,
  prop_missing = 0.3,
  missing_value = -99
)

# increasing proportion of spelling mistakes to 50\%
messy_linelist <- messy_linelist(linelist, prop_spelling_mistakes = 0.5)

# encode `$sex` as `numeric`
messy_linelist <- messy_linelist(
  linelist,
  sex_as_numeric = TRUE,
  inconsistent_sex = FALSE
)

# inconsistently formatted dates
messy_linelist <- messy_linelist(linelist, inconsistent_dates = TRUE)
}
