% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTD_cov.R
\name{BTD_cov}
\alias{BTD_cov}
\title{Bayesian Test of Deficit with Covariates}
\usage{
BTD_cov(
  case_task,
  case_covar,
  control_task,
  control_covar,
  alternative = c("less", "two.sided", "greater"),
  int_level = 0.95,
  iter = 10000,
  use_sumstats = FALSE,
  cor_mat = NULL,
  sample_size = NULL
)
}
\arguments{
\item{case_task}{The case score from the task of interest. Must be a single
value.}

\item{case_covar}{A vector containing the case scores on all covariates
included. Can be of any length except 0, in that case use
\code{\link{BTD}}.}

\item{control_task}{A vector containing the scores from the controls on the
task of interest. Or a vector of length 2 containing the mean and standard
deviation of the task. In that order.}

\item{control_covar}{A vector, matrix or dataframe containing the control
scores on the covariates included. If matrix or dataframe each column
represents a covariate. Or a matrix or dataframe containing summary
statistics where the first column represents the means for each covariate
and the second column represents the standard deviation.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter.}

\item{int_level}{The probability level on the Bayesian credible intervals, defaults to 95\%.}

\item{iter}{Number of iterations to be performed. Greater number gives better
estimation but takes longer to calculate. Defaults to 10000.}

\item{use_sumstats}{If set to \code{TRUE}, \code{control_tasks} and
\code{control_covar} are treated as matrices with summary statistics. Where
the first column represents the means for each variable and the second
column represents the standard deviation.}

\item{cor_mat}{A correlation matrix of all variables included. NOTE: the
first variable should be the task of interest.}

\item{sample_size}{An integer specifying the sample size of the controls.}
}
\value{
A list with class \code{"htest"} containing the following components:
  \tabular{llll}{ \code{statistic}   \tab the average z-value over
  \code{iter} number of iterations. \cr\cr \code{parameter} \tab the degrees
  of freedom used to specify the posterior distribution. \cr\cr
  \code{p.value}    \tab the average p-value over \code{iter} number of
  iterations. \cr\cr \code{estimate} \tab case scores expressed as z-scores
  on task X and Y. Standardised effect size (Z-CCC) of task difference
  between case and controls and point estimate of the proportion of the
  control population estimated to show a more extreme task difference. \cr\cr
  \code{null.value}   \tab the value of the difference between tasks under
  the null hypothesis.\cr\cr \code{interval} \tab named numerical vector
  containing level of confidence and confidence intervals for both effect
  size and p-value.\cr\cr \code{desc}     \tab data frame containing means
  and standard deviations for controls as well as case scores. \cr\cr
  \code{cor.mat} \tab matrix giving the correlations between the task of
  interest and the covariates included. \cr\cr \code{sample.size} \tab number
  of controls..\cr\cr \code{alternative}     \tab a character string
  describing the alternative hypothesis.\cr\cr \code{method} \tab a character
  string indicating what type of test was performed.\cr\cr \code{data.name}
  \tab a character string giving the name(s) of the data}
}
\description{
Takes a single observation and compares it to a distribution estimated by a
control sample, while controlling for the effect of covariates, using
Bayesian methodology. This test is used when assessing a case conditioned on
some other variable, for example, assessing abnormality when controlling for
years of education or sex. Under the null hypothesis the case is an
observation from the distribution of scores from the task of interest coming
from observations having the same score as the case on the covariate(s).
Returns a significance test, point and interval estimates of difference
between the case and the mean of the controls as well as point and interval
estimates of abnormality, i.e. an estimation of the proportion of controls
that would exhibit a more extreme conditioned score. This test is based on
random number generation which means that results may vary between runs. This
is by design and the reason for not using \code{set.seed()} to reproduce
results inside the function is to emphasise the randomness of the test. To
get more accurate and stable results please increase the number of iterations
by increasing \code{iter} whenever feasible. Developed by Crawford,
Garthwaite and Ryan (2011).
}
\details{
Uses random generation of inverse wishart distributions from the
CholWishart package (Geoffrey Thompson, 2019).
}
\examples{

BTD_cov(case_task = size_weight_illusion[1, "V_SWI"],
         case_covar = size_weight_illusion[1, "YRS"],
         control_task = size_weight_illusion[-1, "V_SWI"],
         control_covar = size_weight_illusion[-1, "YRS"], iter = 100)

}
\references{
Crawford, J. R., Garthwaite, P. H., & Ryan, K. (2011). Comparing
  a single case to a control sample: Testing for neuropsychological deficits
  and dissociations in the presence of covariates. \emph{Cortex, 47}(10),
  1166–1178. https://doi.org/10.1016/j.cortex.2011.02.017

Geoffrey Thompson (2019). CholWishart: Cholesky Decomposition of the Wishart
Distribution. R package version 1.1.0.
\url{https://CRAN.R-project.org/package=CholWishart}
}
