% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deficit_power.R
\name{BTD_cov_power}
\alias{BTD_cov_power}
\title{Power calculator for BTD_cov}
\usage{
BTD_cov_power(
  case,
  case_cov,
  control_task = c(0, 1),
  control_covar = c(0, 1),
  cor_mat = diag(2) + 0.3 - diag(c(0.3, 0.3)),
  sample_size,
  alternative = c("less", "greater", "two.sided"),
  alpha = 0.05,
  nsim = 1000,
  iter = 1000
)
}
\arguments{
\item{case}{A single value from the expected case observation on the task of
interest.}

\item{case_cov}{A vector of expected case observations from covariates of
interest.}

\item{control_task}{A vector of length 2 containing the expected mean and standard
deviation of the task of interest. In that order.}

\item{control_covar}{A matrix with 2 columns containing expected means (in the 1st
column) and standard deviations (in the 2nd column) of the included
covariates.}

\item{cor_mat}{A correlation matrix containing the correlations of the
task of interest and the coviariate(s). The first variable is treated as
the task of interest. Defaults to a correlation of 0.3 between the covariate
and the variate of interest.}

\item{sample_size}{Single value of the size of the sample for which you wish
to calculate power.}

\item{alternative}{The alternative hypothesis. A string of either "less" (default),
"greater" or "two.sided".}

\item{alpha}{The specified Type I error rate. This can also be varied, with
effects on power.}

\item{nsim}{The number of simulations for the power calculation. Defaults to
1000 due to BTD_cov already being computationally intense.}

\item{iter}{The number of simulations used by the BTD_cov. Defaults to 1000.}
}
\value{
Returns a single value approximating the power of the test for the
  given parameters.
}
\description{
Computationally intense. Lower \code{iter} and/or \code{nsim} for less exact
but faster calculations. Calculates approximate power, given sample size,
using Monte Carlo simulation for the Bayesian test of deficit with covariates
for specified (expected) case score, means and standard deviations for the
control sample on the task of interest and included covariates. The number of
covariates defaults to 1, means and standard deviations for the task and
covariate defaults to 0 and 1, so if no other values are given the case score
is interpreted as deviation from the mean in standard deviations for both task
and covariate.
}
\examples{
cor_mat = matrix(c(1, 0.2, 0.3, 0.2, 1, 0.4, 0.3, 0.4, 1), ncol = 3)

BTD_cov_power(case = -2, case_cov = c(105, 30), control_task = c(0, 1),
control_covar = matrix(c(100, 40, 15, 10), ncol = 2), sample_size = 15,
cor_mat = cor_mat, iter = 20, nsim = 20)
}
