% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_IO.R
\name{write_haystack}
\alias{write_haystack}
\title{Function to write haystack result data to file.}
\usage{
write_haystack(res.haystack, file)
}
\arguments{
\item{res.haystack}{A 'haystack' result variable}

\item{file}{A file to write to}
}
\description{
Function to write haystack result data to file.
}
\examples{
# using the toy example of the singleCellHaystack package
# define a logical matrix with detection of each gene (rows) in each cell (columns)
dat.detection <- dat.expression > 1

# running haystack in default mode
res <- haystack(dat.tsne, detection=dat.detection, method = "2D")

outfile <- file.path(tempdir(), "output.csv")

# write result to file outfile.csv
write_haystack(res, file = outfile)

# read in result from file
res.copy <- read_haystack(file = outfile)
}
