% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{mergePTMAbundance}
\alias{mergePTMAbundance}
\title{Merge the original and PTM versions of the proteins.}
\usage{
mergePTMAbundance(df)
}
\arguments{
\item{df}{A dataframe with the abundance of the different molecules over time (from \code{\link{simulateInSilicoSystem}}
or \code{\link{simulateParallelInSilicoSystem}}).}
}
\value{
A dataframe in which the abundance of original and modified versions of a protein have been merged to give the abundance of the protein (without distinction of its post-translational modification state).
}
\description{
Merge (i.e. sum) the abundance of the original and modified (PTM) versions of each protein in the results of a simulation.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 5, PC.p = 1, PC.PTM.p = 0.9, regcomplexes = "none", ploidy = 1)
mypop = createInSilicoPopulation(1, mysystem)
sim = simulateInSilicoSystem(mysystem, mypop, 100)
head(sim$Simulation)
mergedPTM = mergePTMAbundance(sim$Simulation)
head(mergedPTM)
}
}
