% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.probs_cube}
\alias{plot.probs_cube}
\title{Plot probability cubes}
\usage{
\method{plot}{probs_cube}(
  x,
  ...,
  tiles = NULL,
  labels = NULL,
  breaks = "pretty",
  n_colors = 20,
  palette = "Terrain"
)
}
\arguments{
\item{x}{Object of class "probs_image".}

\item{...}{Further specifications for \link{plot}.}

\item{tiles}{Tiles to be plotted.}

\item{labels}{Labels to plot (optional).}

\item{breaks}{Type of class intervals.}

\item{n_colors}{Number of colors to plot.}

\item{palette}{HCL palette used for visualization.}
}
\value{
A plot object produced by the stars package
                      containing maps of probabilities associated
                      to each class for each pixel.
}
\description{
plots a probability cube using stars
}
\note{
\itemize{Possible class intervals
 \item{"sd":} {intervals based on the average and standard deviation.}
 \item{"equal": } {divides the range of the variable into n parts.}
 \item{"pretty": } {number of breaks likely to be legible.}
 \item{"quantile": } {quantile breaks}
 \item{"log": }{logarithm plot}
 }

The function accepts color palettes are defined in grDevices::hcl.pals()
}
\examples{
if (sits_run_examples()) {
    # select a set of samples
    samples_ndvi <- sits_select(samples_modis_4bands, bands = c("NDVI"))
    # create a random forest model
    rfor_model <- sits_train(samples_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "X2", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # plot the resulting probability cube
    plot(probs_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
