% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.geo_distances}
\alias{plot.geo_distances}
\title{Make a kernel density plot of samples distances.}
\usage{
\method{plot}{geo_distances}(x, y, ...)
}
\arguments{
\item{x}{Object of class "geo_distances".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}
}
\value{
A plot showing the sample-to-sample distances
                      and sample-to-prediction distances.
}
\description{
Make a kernel density plot of samples distances.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # read a shapefile for the state of Mato Grosso, Brazil
    mt_shp <- system.file("extdata/shapefiles/mato_grosso/mt.shp",
        package = "sits"
    )
    # convert to an sf object
    mt_sf <- sf::read_sf(mt_shp)
    # calculate sample-to-sample and sample-to-prediction distances
    distances <- sits_geo_dist(samples_modis_ndvi, mt_sf)
    # plot sample-to-sample and sample-to-prediction distances
    plot(distances)
}
}
\references{
Hanna Meyer and Edzer Pebesma,
"Machine learning-based global maps of ecological variables and the
challenge of assessing them" Nature Communications, 13,2022.
DOI: 10.1038/s41467-022-29838-9.
}
\author{
Felipe Souza, \email{lipecaso@gmail.com}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
