% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sju.mean.n}
\alias{sju.mean.n}
\title{Compute row means with min amount of valid values}
\usage{
sju.mean.n(df, n)
}
\arguments{
\item{df}{a \link{data.frame} with at least two columns, where row means are applied.}

\item{n}{the amount of valid values per row to calculate the row mean. If a row's valid
         values is smaller than \code{n}, \link{NA} will be returned as row mean value.}
}
\value{
A vector with row mean values of \code{df} for those rows with at least \code{n}
          valid values. Else, \link{NA} is returned.
}
\description{
This function is similar to the SPSS \code{MEAN.n} function and computes
               row means from a \link{data.frame} or \link{matrix} if at least \code{n}
               values of a row a valid (and not \link{NA}).
}
\examples{
df <- data.frame(a=c(1,2,NA,4), b=c(NA,2,NA,5), c=c(NA,4,NA,NA), d=c(2,3,7,8))
sju.mean.n(df, 4) # 1 valid return value
sju.mean.n(df, 3) # 2 valid return values
sju.mean.n(df, 2)
sju.mean.n(df, 1) # all means are shown
}
\references{
\itemize{
             \item \href{http://candrea.ch/blog/compute-spss-like-mean-index-variables/}{candrea's blog}
             \item \href{http://r4stats.com/2014/09/03/adding-the-spss-mean-n-function-to-r/}{r4stats.com}
             }
}

