% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{importance}
\alias{importance}
\title{importance}
\usage{
importance(x, save_memory = TRUE, ...)
}
\arguments{
\item{x}{object fitted by \code{\link{sjSDM}} or a list with beta, the association matrix, and the correlation matrix of the predictors, see details below}

\item{save_memory}{use torch backend to calculate importance with single precision floats}

\item{...}{additional arguments}
}
\value{
An S3 class of type 'sjSDMimportance' including the following components:

\item{names}{Character vector, species names.}
\item{res}{Data frame of results.}
\item{spatial}{Logical, spatial model or not.}

Implemented S3 methods include \code{\link{print.sjSDMimportance}} and \code{\link{plot.sjSDMimportance}}
}
\description{
Computes standardized variance components with respect to abiotic, biotic, and spatial effect groups.
}
\details{
This variance partitioning approach is based on Ovaskainen et al., 2017. For an example how to interpret the outputs, see Leibold et al., 2021.
This function will be deprecated in the future. Please use \code{plot(anova(model), internal=TRUE)} (currently only supported for spatial models).
}
\examples{
\dontrun{
library(sjSDM)
com = simulate_SDM(sites = 300L, species = 12L, 
                   link = "identical", response = "identical")
Raw = com$response
SP = matrix(rnorm(300*2), 300, 2)
SPweights = matrix(rnorm(12L), 1L)
SPweights[1,1:6] = 0
Y = Raw + (SP[,1,drop=FALSE]*SP[,2,drop=FALSE]) \%*\% SPweights
Y = ifelse(Y > 0, 1, 0)

model = sjSDM(Y = Y,env = linear(com$env_weights, lambda = 0.001), 
              spatial = linear(SP,formula = ~0+X1:X2, lambda = 0.001), 
              biotic = bioticStruct(lambda = 0.001),iter = 40L)
imp = importance(model)
plot(imp)
}
}
\references{
Ovaskainen, O., Tikhonov, G., Norberg, A., Guillaume Blanchet, F., Duan, L., Dunson, D., ... & Abrego, N. (2017). How to make more out of community data? A conceptual framework and its implementation as models and software. Ecology letters, 20(5), 561-576.

Leibold, M. A., Rudolph, F. J., Blanchet, F. G., De Meester, L., Gravel, D., Hartig, F., ... & Chase, J. M. (2021). The internal structure of metacommunities. Oikos.
}
\seealso{
\code{\link{print.sjSDMimportance}}, \code{\link{plot.sjSDMimportance}}
}
\author{
Maximilian Pichler
}
