% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_labels.R
\name{fill_labels}
\alias{fill_labels}
\title{Add missing value labels to partially labelled vector}
\usage{
fill_labels(x)
}
\arguments{
\item{x}{Variable (vector), \code{data.frame} or \code{list} of variables
with partially added value labels (see \code{\link[haven]{labelled}}).}
}
\value{
\code{x}, where labels for non-labelled values are added.
}
\description{
This function adds value labels to a partially labelled vector,
               i.e. if not all values are labelled, non-labelled values
               get labels.
}
\examples{
# create labelled integer, with missing flag
x <- labelled(c(1, 2, 1, 3, 4, 1, 5),
              c(Good = 1, Bad = 5))
get_labels(x)
get_labels(x, include.non.labelled = TRUE)

fill_labels(x)
get_labels(fill_labels(x))

# create partially labelled vector with missings
x <- labelled(c(1, 2, 1, 3, 4, 1, 5),
              c(Male = 1, Female = 2, Refused = 5),
              c(FALSE, FALSE, TRUE))
x
fill_labels(x)
get_labels(fill_labels(x))

# get summary
x <- labelled(c(1, 2, 1, 3, 4, 1, NA, 5),
              c(Male = 1, Female = 2, Refused = 5),
              c(FALSE, FALSE, TRUE))
frq(x)

}
\seealso{
\code{\link{drop_labels}} is the counterpart to \code{fill_labels}
           and drops labels from zero-count (non-existing) values.
}

