% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{skipTrack.fit}
\alias{skipTrack.fit}
\title{Fits the skipTrack Model using 1 or more MCMC chains}
\usage{
skipTrack.fit(
  Y,
  cluster,
  X = matrix(1, nrow = length(cluster)),
  Z = matrix(1, nrow = length(cluster)),
  numSkips = 10,
  reps = 1000,
  chains,
  useParallel = FALSE,
  ...
)
}
\arguments{
\item{Y}{A vector of observed cycle lengths.}

\item{cluster}{A vector indicating the individual cluster/group membership for each observation Y.}

\item{X}{A matrix (length(Y) x length(Beta)) of covariates for cycle length mean. Default is a vector of 1's.}

\item{Z}{A matrix (length(Y) x length(Gamma)) of covariates for cycle length precision. Default is a vector of 1's.}

\item{numSkips}{The maximum number of skips to allow. Default is 10.}

\item{reps}{The number of MCMC iterations (steps) to perform. Default is 1000.}

\item{chains}{Number of chains to run.}

\item{useParallel}{Logical, indicating whether to use parallel processing, as supported by doParallel. Default is FALSE.}

\item{...}{
  Arguments passed on to \code{\link[=skipTrack.MCMC]{skipTrack.MCMC}}
  \describe{
    \item{\code{fixedSkips}}{If TRUE cycle skip information (cijs) is not updated in sample steps and the inputs are instead assumed to be true.}
    \item{\code{initialParams}}{A list of initial parameter values for the MCMC algorithm.
Default values are provided for pi, muis, tauis, rho, cijs, alphas, Beta, Gamma, phi, rhoBeta, rhoGamma, and rhoPhi.}
    \item{\code{verbose}}{logical. If true progress bars and additional info are printed to the console.}
  }}
}
\value{
A list containing the results of skipTrack.MCMC for each chain.
}
\description{
This function fits the model using multiple instances of skipTrack.MCMC, either in parallel or sequentially.
}
\examples{
#Simulated data
simDat <- skipTrack.simulate(n = 100, skipProb = c(.7, .2, .1))

#Run model fit (should typically run with much more than 50 reps)
modFit <- skipTrack.fit(Y = simDat$Y, cluster = simDat$cluster, chains = 2, reps = 50)
modFit

}
\seealso{
\code{\link{skipTrack.MCMC}}
}
