% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_avatar_picture.R
\name{get_avatar_picture}
\alias{get_avatar_picture}
\title{Display Avatar}
\usage{
get_avatar_picture(avatar_id, type = "full", keep_image = FALSE)
}
\arguments{
\item{avatar_id}{Avatar ID generated by Sleeper (character)}

\item{type}{String that is either "full" or "thumbnail"}

\item{keep_image}{FALSE to delete the image after displaying it or TRUE to keep it}
}
\value{
Returns a picture displaying the avatar picture
}
\description{
Given an avatar ID, grab the picture (full or thumbnail) concerning that particular avatar.
Note that this function downloads the image into your temporary directory to display 
it. Then, the function deletes the file before completing. If it would be preferred to keep
the image at the temporary location, set the keep_image argument to TRUE (default is FALSE).
}
\examples{
\dontrun{get_avatar_picture("c751b27d9158c1dd41bd33dc7e4bcdde",
   type = "full",
   keep_image = FALSE)}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, October 2021
}
\keyword{avatar}
\keyword{picture}
