% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_mutate}
\alias{ts_mutate}
\title{Add mutations to the given tree sequence}
\usage{
ts_mutate(
  ts,
  mutation_rate,
  random_seed = NULL,
  keep_existing = TRUE,
  mut_type = NULL
)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{mutation_rate}{Mutation rate used by msprime to simulate mutations}

\item{random_seed}{Random seed passed to msprime's \code{mutate} method}

\item{keep_existing}{Keep existing mutations?}

\item{mut_type}{Assign SLiM mutation type to neutral mutations? If
\code{NULL} (default), no special mutation type will be used. If an
integer number is given, mutations of the SLiM mutation type with that
integer identifier will be created.}
}
\value{
Tree-sequence object of the class \code{slendr_ts}, which serves as
an interface point for the Python module tskit using slendr functions with
the \code{ts_} prefix.
}
\description{
Add mutations to the given tree sequence
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

ts <- ts_load(slendr_ts, model)
ts_mutate <- ts_mutate(ts, mutation_rate = 1e-8, random_seed = 42)

ts_mutate
}
\seealso{
\code{\link{ts_nodes}} for extracting useful information about
individuals, nodes, coalescent times and geospatial locations of nodes on a
map
}
