% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_genotypes}
\alias{ts_genotypes}
\title{Extract genotype table from the tree sequence}
\usage{
ts_genotypes(ts)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}
}
\value{
Data frame object of the class \code{tibble} containing genotypes
of simulated individuals in columns
}
\description{
Extract genotype table from the tree sequence
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression_slim.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk, recapitate it, simplify it, and mutate it
ts <- ts_load(slendr_ts, model) \%>\%
  ts_recapitate(Ne = 10000, recombination_rate = 1e-8) \%>\%
  ts_simplify() \%>\%
  ts_mutate(mutation_rate = 1e-8)

# extract the genotype matrix (this could take  a long time consume lots
# of memory!)
gts <- ts_genotypes(ts)
}
