% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-method.R
\name{confint.slm}
\alias{confint.slm}
\title{Confidence intervals for the Model Parameters}
\usage{
\method{confint}{slm}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{a fitted model object of class \code{slm}.}

\item{parm}{a specification of which parameters are to be given confidence intervals,
that is a vector of numbers. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional argument(s) for methods.}
}
\value{
This function returns the confidence intervals for the parameters of the model.
}
\description{
Computes confidence intervals for the model parameters.
}
\examples{
data("shan")
reg1 = slm(shan$PM_Xuhui ~ . , data = shan, method_cov_st = "fitAR", model_selec = -1)
confint(reg1, level = 0.8)

data("co2")
y = as.vector(co2)
x = as.vector(time(co2)) - 1958
reg2 = slm(y ~ x + I(x^2) + I(x^3) + sin(2*pi*x) + cos(2*pi*x) + sin(4*pi*x) +
 cos(4*pi*x) + sin(6*pi*x) + cos(6*pi*x) + sin(8*pi*x) + cos(8*pi*x),
 method_cov_st = "fitAR", model_selec = -1, plot = TRUE)
confint(reg2, level = 0.9)
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
\seealso{
\code{\link[stats:confint.lm]{confint.lm}}.
}
