% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apStressMin.R
\name{apStressMin}
\alias{apStressMin}
\alias{apowerstressMin}
\alias{apostmds}
\alias{apstressMin}
\alias{apstressmds}
\title{Approximate Power Stress SMACOF}
\usage{
apStressMin(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  type = "ratio",
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

apowerstressMin(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  type = "ratio",
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

apostmds(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  type = "ratio",
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

apstressMin(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  type = "ratio",
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)

apstressmds(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  type = "ratio",
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{kappa}{power of the transformation of the fitted distances; defaults to 1}

\item{lambda}{the power of the transformation of the proximities; defaults to 1}

\item{nu}{the power of the transformation for weightmat; defaults to 1}

\item{type}{what type of MDS to fit. Only "ratio" currently.}

\item{weightmat}{a binary matrix of finite nonegative weights.}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{acc}{numeric accuracy of the iteration. Default is 1e-6.}

\item{itmax}{maximum number of iterations. Default is 10000.}

\item{verbose}{should iteration output be printed; if > 1 then yes}

\item{principal}{If 'TRUE', principal axis transformation is applied to the final configuration}
}
\value{
a 'smacofP' object (inheriting from 'smacofB', see \code{\link{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed, untransformed dissimilarities
\item tdelta: Observed explicitly transformed dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats), optimally scaled and normalized 
\item confdist: Configuration dissimilarities
\item conf: Matrix of fitted configuration
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point 
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model 
\item weightmat: weighting matrix as supplied 
\item stress.m: Default stress (stress-1^2)
\item tweightmat: transformed weightingmatrix (here weightmat^nu)
}
}
\description{
An implementation to minimize power stress by majorization with ratio or interval optimal scaling. Usually more accurate but slower than 'powerStressFast'. Uses a repeat loop.
}
\section{Note}{

Internally we calculate the approximation parameters upsilon=nu+2*lambda*(1-(1/kappa)) and tau=lambda/kappa. They are not output.
}

\examples{
dis<-smacof::kinshipdelta
res<-apStressMin(as.matrix(dis),kappa=2,lambda=1.5,itmax=1000)
res
summary(res)
plot(res)
plot(res,"Shepard")
plot(res,"transplot")

}
