% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVerror.R
\name{CVerrorknn}
\alias{CVerrorknn}
\title{k-Fold Cross Validation Error Rate for KNN}
\usage{
CVerrorknn(pred, resp, K = 1, k = nrow(pred))
}
\arguments{
\item{pred}{A dataset with predictors}

\item{resp}{A vector with responses}

\item{K}{The number of neighborhoods to consider when performing KNN}

\item{k}{The number of folds}
}
\value{
The k-fold CV error rate if k is entered, otherwise the LOOCV error rate.
}
\description{
Given a dataset with predictors and a vector with responses, a number of
neighbors K, and a number of folds k, the k-fold CV error rate for KNN is 
calculated.
}
\examples{
mtcars$am=as.factor(mtcars$am)
CVerrorknn(mtcars[,c("mpg","hp")],mtcars$am)
}
