% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movres.R
\name{fitMRME}
\alias{fitMRME}
\alias{fitMRME_naive}
\alias{fitMRMEapprox}
\title{Fit a Moving-Resting Model with Measurement Error}
\usage{
fitMRME(
  data,
  start,
  segment = NULL,
  lower = c(1e-06, 1e-06, 1e-06, 1e-06),
  upper = c(10, 10, 10, 10),
  integrControl = integr.control()
)

fitMRME_naive(
  data,
  start,
  segment = NULL,
  lower = c(1e-06, 1e-06, 1e-06, 1e-06),
  upper = c(10, 10, 10, 10),
  integrControl = integr.control()
)

fitMRMEapprox(
  data,
  start,
  segment = NULL,
  approx_norm_even = approxNormalOrder(5),
  approx_norm_odd = approxNormalOrder(6),
  method = "Nelder-Mead",
  optim.control = list(),
  integrControl = integr.control()
)
}
\arguments{
\item{data}{a data.frame whose first column is the observation time, and other
columns are location coordinates. If \code{segment} is not \code{NULL},
additional column with the same name given by \code{segment} should be
included. This additional column is used to indicate which part of
observations shoule be used to fit model. The value of this column can
be any integer with 0 means discarding this observation and non-0 means
using this obversvation. Using different non-zero numbers indicate different
segments. (See vignette for more details.)}

\item{start}{starting value of the model, a vector of four components
in the order of rate for moving, rate for resting, volatility, and
s.d. of Guassian measurement error.}

\item{segment}{character variable, name of the column which indicates segments,
in the given \code{data.frame}. The default value, \code{NULL}, means using
whole dataset to fit the model.}

\item{lower, upper}{Lower and upper bound for optimization.}

\item{integrControl}{a list of control parameters for the \code{integrate}
function: rel.tol, abs.tol, subdivision.}

\item{approx_norm_even, approx_norm_odd}{numeric matrixes specify the
discrete distributions used to approximate standard normal distribution.
The first column is support of discrete distribution and the second
column is probability mass function. \code{approx_norm_even} is used to
approximate even step error and \code{approx_norm_odd} is used to
approximate odd step error. We mention that the supports of these two
discrete distributions should not have any common elements.}

\item{method}{the method argument to feed \code{optim}.}

\item{optim.control}{a list of control to be passed to \code{optim}.}
}
\value{
a list of the following components:
\item{estimate}{the esimated parameter vector}
\item{loglik}{maximized loglikelihood or composite loglikelihood
evaluated at the estimate}
\item{convergence}{convergence code from \code{optim}}
}
\description{
'fitMRME' fits a Moving-Resting Model with Measurement Error. The measurement
error is modeled by Guassian noise. Using \code{segment} to fit part
of observations to the model. A practical application of this feature
is seasonal analysis.
}
\examples{
## time consuming example
#tgrid <- seq(0, 10*100, length=100)
#set.seed(123)
#dat <- rMRME(tgrid, 1, 0.5, 1, 0.01, "m")

## fit whole dataset to the MRME model
#fit <- fitMRME(dat, start=c(1, 0.5, 1, 0.01))
#fit

## fit whole dataset to the MRME model with naive composite likelihood
#fit.naive <- fitMRME_naive(dat, start=c(1, 0.5, 1, 0.01))
#fit.naive

## fit whole dataset to the MRME model with approximate error
#fit.approx <- fitMRMEapprox(dat, start=c(1, 0.5, 1, 0.01))
#fit.approx

## fit part of dataset to the MR model
#batch <- c(rep(0, 5), rep(1, 17), rep(0, 4), rep(2, 30), rep(0, 4), rep(3, 40))
#dat.segment <- cbind(dat, batch)
#fit.segment <- fitMRME(dat.segment, start = c(1, 0.5, 1, 0.01), segment = "batch")
#fit.segment.approx <- fitMRMEapprox(dat.segment, start = c(1, 0.5, 1, 0.01), segment = "batch")
#head(dat.segment)
#fit.segment

}
\references{
Hu, C., Pozdnyakov, V., and Yan, J. Moving-resting model with measurement
error. In process.
}
\author{
Chaoran Hu
}
