% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm3.R
\name{sm3_hash}
\alias{sm3_hash}
\alias{sm3_hash_string}
\alias{sm3_hash_file}
\title{SM3 Hash}
\usage{
sm3_hash(msg)

sm3_hash_string(msg_string)

sm3_hash_file(file_path)
}
\arguments{
\item{msg}{data to be hashed}

\item{msg_string}{a character string to be hashed}

\item{file_path}{a local file to be hashed}
}
\value{
a 64-characters hex string, which will be the sm3 hash result of the data, string or file
}
\description{
SM3 is a cryptographic hash function designed for digital signatures and
other cryptographic applications. The output of SM3 is a 256-bit hash value,
which is commonly represented as a 64-hexadecimal digit string.
}
\details{
All the functions mentioned - \link{sm3_hash}, \link{sm3_hash_string}, and \link{sm3_hash_file} -
return a 64-character hexadecimal string representing the 256-bit hash value
generated by the SM3 cryptographic hash function. This hexadecimal string is
commonly used to represent the hash output in a human-readable format.
The \link{sm3_hash} function calculates the SM3 hash of a raw vector input and
returns a 64-character hexadecimal string. Similarly, \link{sm3_hash_string} takes
a string as input and also returns a 64-character hexadecimal string
representing the SM3 hash of the input string. The \link{sm3_hash_file} function,
on the other hand, takes a file path as input, reads the contents of the file,
calculates its SM3 hash, and returns the corresponding 64-character hexadecimal string.
}
\examples{
## Raw vector hashing
msg <- charToRaw('abc')
sm3_hash(msg)

## character string hashing
sm3_hash_string('abc')

## local file hashing
\dontrun{
  sm3_hash_file('test.docx')
}
}
