% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic.nn.R
\name{elliptic.nn}
\alias{elliptic.nn}
\title{Nearest neighbors for elliptic scan}
\usage{
elliptic.nn(
  coords,
  pop,
  ubpop = 0.5,
  shape = c(1, 1.5, 2, 3, 4, 5),
  nangle = c(1, 4, 6, 9, 12, 15)
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{pop}{The population size associated with each
region.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{shape}{The ratios of the major and minor axes of
the desired ellipses.}

\item{nangle}{The number of angles (between 0 and 180) to
consider for each shape.}
}
\value{
A list of nested nearest neighbors, the
  associated shapes and angles for each set of nn, and
  all of the shapes and angles you get for each zone
  constructed from the set of nearest neighbors.
}
\description{
\code{elliptic.nn} computes the nearest neighbors
relationships for \code{elliptic.test}.  It will provide
a list of nearest neighbors, and a list of the associated
shape and angle.
}
\examples{
data(nydf)
coords = with(nydf, cbind(longitude, latitude))
enn = elliptic.nn(coords, nydf$pop, 0.1,
                  shape = c(1, 1.5), nangle = c(1, 4))
}
