% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pAIC}
\alias{pAIC}
\title{Point AIC}
\usage{
pAIC(object, ...)
}
\arguments{
\item{object}{Time series model.}

\item{...}{Some stuff.}
}
\value{
The function returns the vector of point AIC values.
}
\description{
This function returns a vector of AIC values for the in-sample observations
}
\details{
This is based on \link[smooth]{pointLik} function. The formula for this is:
pAIC_t = 2 * k - 2 * T * l_t ,
where k is the number of parameters, T is the number of observations and l_t is
the point likelihood. This way we preserve the property that AIC = mean(pAIC).
}
\examples{

ourModel <- ces(rnorm(100,0,1),h=10)

pAICValues <- pAIC(ourModel)

mean(pAICValues)
AIC(ourModel)

}
\seealso{
\link[smooth]{pointLik}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
