% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef_reest}
\alias{coef_reest}
\alias{coef_reest.glmsmurf}
\alias{coefficients_reest}
\alias{coefficients_reest.glmsmurf}
\title{Coefficients of Re-estimated Model}
\usage{
coef_reest(object, ...)

\method{coef_reest}{glmsmurf}(object, ...)

coefficients_reest(object, ...)

\method{coefficients_reest}{glmsmurf}(object, ...)
}
\arguments{
\item{object}{An object for which the extraction of model coefficients is meaningful. 
E.g. an object of class '\code{\link[=glmsmurf-class]{glmsmurf}}', typically the result of a call to \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}}.}

\item{...}{Additional arguments which are currently ignored.}
}
\value{
A vector containing the coefficients of the re-estimated model in \code{object}, 
        when they are available, or, otherwise, the coefficients of the estimated model in \code{object} with a warning.
}
\description{
Function to extract the coefficients of the re-estimated model. 
             \code{coefficients_reest} is an \emph{alias} for it.
}
\examples{
## See example(glmsmurf) for examples

}
\seealso{
\code{\link{coef.glmsmurf}}, \code{\link[stats]{coef}}, \code{\link{summary.glmsmurf}}, \code{\link{glmsmurf}}, \code{\link{glmsmurf-class}}
}
