% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.equation.R
\name{model.equation}
\alias{model.equation}
\title{Generate a Model Equation from a Linear Model}
\usage{
model.equation(model, latex = TRUE)
}
\arguments{
\item{model}{A linear model object (e.g., output from `lm()`).}

\item{latex}{A logical value indicating whether to return a LaTeX-formatted equation (default: TRUE). If FALSE, the equation is printed to the console.}
}
\value{
If `latex` is TRUE, the equation is returned as LaTeX code using `knitr::asis_output()`. If FALSE, the equation is printed to the console.
}
\description{
This function extracts and formats the equation from a linear model object.
It includes an option to return the equation as a LaTeX-formatted string or print it to the console.
}
\examples{
# Fit a linear model
model <- lm(mpg ~ wt + hp, data = mtcars)

# Get LaTeX equation
model.equation(model)

# Print equation to console
print(model.equation(model, latex = FALSE))

}
