% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeSeasonalPeriod.R
\name{removeSeasonalPeriod}
\alias{removeSeasonalPeriod}
\title{Remove Seasonal Period}
\usage{
removeSeasonalPeriod(x, period, time = 1:length(x))
}
\arguments{
\item{x}{The time series to be analyzed.}

\item{period}{The period of the seasonality of the data.}

\item{time}{If not provided, then the observations are assumed to occur at
integer times 1, 2, ..., length(x).  Otherwise, the time vector may specify
when these observations occur.}
}
\value{
Returns a vector of data with the seasonality component removed.
}
\description{
This function estimates the seasonal period of a time series via a GAM
model.  The data series with the seasonal period removed is then returned.
}
\author{
Josh Browning (jbrownin@mines.edu)
}
