\name{snpar-package}
\alias{snpar-package}
\alias{snpar}
\docType{package}
\title{
Supplementary Non-parametric Statistics Methods
}
\description{
Provide supplementary non-parametric statistics methods to perform several non-parametric tests based on rank score, estimate kernel probability density and cumulative distribution function, and fit kernel regression.
}
\details{
\tabular{ll}{
Package: \tab snpar\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2014-08-12\cr
License: \tab GPL (>= 2)\cr
}
This package contains several supplementary non-parametric statistics methods, including one- or two-sample quantile test and normal score test as well as multiple-sample normal score test, Cox-Stuart trend test, runs test for randomness, kernel PDF and CDF estimation, kernel regression estimation and kernel Kolmogorov-Smirov test.

For a complete list of functions, use \code{library(help = snpar)}.
}
\author{
Debin Qiu

Maintainer: Debin Qiu <\email{debinqiu@uga.edu}>
}
\references{
Abdi, H. (2007). Bonferroni and Sidak corrections for multiple comparisons. In Salkind, N. J. \emph{Encyclopedia of Measurement and Statistics}. Thousand Oaks, CA: Sage.

Conover, W. J. (1999). \emph{Practical Nonparameteric Statistics} (Third Edition ed.). Wiley. pp. 396-406.

 D.R. Cox and A. Stuart (1955). Some quick sign tests for trend in location and dispersion. \emph{Biometrika}, Vol. 42, pp. 80-95.
 
 Fan, I. Gijbels (1996). \emph{Local Polynomial Modeling and its Applications}. Chapman & Hall, London.
 
 Li, Qi; Racine, Jeffrey S. (2007). \emph{Nonparametric Econometrics: Theory and Practice}. Princeton University Press. ISBN 0-691-12161-3.
 
 Nadaraya, E. A. (1964). On Estimating Regression. \emph{Theory of Probability and its Applications} 9(1): 141-2.
 
 Wald, A. and Wolfowitz, J. (1940). On a test whether two samples are from the same population. \emph{Ann. Math Statist.} 11, 147-162.
 
 Wand, M. P. and Jones, M. C. (1995). \emph{Kernel Smoothing}. Chapman and Hall, London.

Wang, J., Cheng, F. and Yang, L. (2013). Smooth simultaneous confidence bands for cumulative distribution functions. \emph{Journal of Nonparametric Statistics}. 25, 395-407.

Wu, X. and Zhao, B. (2013). \emph{Nonparametric Statistics} (Fourth Edition ed). China Statistics Press.
}
\keyword{ package }
