% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_solution.R
\name{get_solution}
\alias{get_solution}
\title{Get an Astronomical Solution}
\usage{
get_solution(astronomical_solution = "PT-ZB18a", quiet = FALSE, force = FALSE)
}
\arguments{
\item{astronomical_solution}{Character vector with the name of the desired
solution.}

\item{quiet}{Be quiet?
\itemize{
\item If \code{TRUE}, hide info messages.
\item If \code{FALSE} (the default) print info messages and timing.
}}

\item{force}{Force re-downloading the results, even if the solution is saved
to the cache.}
}
\value{
A \link[tibble:tibble-package]{tibble} with the astronomical solution
(and some preprocessed new columns).
}
\description{
Download supported astronomical solutions from the web and store it in the
user's cache directory. The next use of the function will load the data from
the cache rather than downloading it again. This also provides a wrapper for
\code{\link[astrochron:getLaskar]{astrochron::getLaskar()}} if one of their supported solutions is specified,
but converts the output to a \link[tibble:tibble-package]{tibble}. Note that we
do not cache these solutions locally, however.
}
\examples{
\donttest{
get_solution("PT-ZB18a")
get_solution("ZB20a")
get_solution("La11")
}
}
\references{
Zeebe, R. E., & Lourens, L. J. (2019). Solar System chaos and the
Paleocene–Eocene boundary age constrained by geology and astronomy.
\emph{Science}, 365(6456), 926–929. \doi{10.1126/science.aax0612}.

Zeebe, R. E. and Lourens, L. J. (2022). A deep-time dating tool for
paleo-applications utilizing obliquity and precession cycles: The role of
dynamical ellipticity and tidal dissipation. \emph{Paleoceanography and
Paleoclimatology}. \doi{10.1029/2021PA004349}
}
\seealso{
\link{PT_ZB18a}, \link{ZB17}, \link{ZB18a}, \link{ZB20}
}
